/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.util;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.springframework.ide.eclipse.boot.util.Thunk;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class RetryUtil {
    public static void retryWhen(String name, int tries, Predicate<Throwable> when, Thunk task) throws Exception {
        boolean success = false;
        Throwable error = null;
        while (!success && tries > 0) {
            --tries;
            try {
                task.call();
                success = true;
            }
            catch (Throwable e) {
                error = e;
                if (name == null || tries <= 0 || !when.test(e)) continue;
                System.out.println(String.valueOf(name) + " failed: " + ExceptionUtil.getMessage((Throwable)e));
                System.out.println("Retrying!");
            }
        }
        if (!success) {
            throw ExceptionUtil.exception(error);
        }
    }

    public static void retryTimes(String name, int tries, Thunk task) throws Exception {
        RetryUtil.retryWhen(name, tries, e -> true, task);
    }

    public static <T> T retry(long interval, long timelimit, Callable<T> task) throws Exception {
        T result = null;
        boolean success = false;
        Throwable error = null;
        long endTime = System.currentTimeMillis() + timelimit;
        do {
            try {
                result = task.call();
                success = true;
            }
            catch (Throwable e) {
                error = e;
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (!success && System.currentTimeMillis() < endTime);
        if (success) {
            return result;
        }
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw new InvocationTargetException(error);
    }

    public static Predicate<Throwable> errorWithMsg(String msgFrag) {
        return error -> {
            String msg = ExceptionUtil.getMessage((Throwable)error);
            return msg.contains(msgFrag);
        };
    }

    public static <T> T until(long interval, long timeout, Predicate<T> condition, Callable<T> body) throws Exception {
        long endTime = Math.max(System.currentTimeMillis() + timeout, timeout);
        T result = body.call();
        while (System.currentTimeMillis() < endTime && !condition.test(result)) {
            Thread.sleep(interval);
            result = body.call();
        }
        return result;
    }
}

