/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IFrameworkCommand;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.actions.AbstractActionDelegate;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard.GenericCommandWizard;

public abstract class AbstractCommandActionDelegate
extends AbstractActionDelegate {
    private IFrameworkCommand selectedCommand = null;

    @Override
    public void selectionChanged(IAction action, ISelection sel) {
        this.debug("Selection Changed: " + sel);
        if (sel != null) {
            super.selectionChanged(action, sel);
            this.selectedCommand = this.getSelectedCommand(action, sel);
        }
    }

    public void run(IAction action) {
        List<IProject> projects = this.getSelectedProjects();
        IProject project = null;
        if (projects != null) {
            project = this.getSelectedProjects().get(0);
        }
        if (project != null) {
            GenericCommandWizard wizard;
            LinkedHashSet<IProject> allProjects = new LinkedHashSet<IProject>();
            allProjects.add(project);
            Collection<IProject> selectionProjects = this.getSelectionProjects(project);
            if (selectionProjects != null) {
                allProjects.addAll(selectionProjects);
            }
            if ((wizard = this.getCommandWizard(allProjects, this.selectedCommand)) == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Unable to find command wizard", (String)"No command wizard found. This action requires a command wizard. Please contact STS support.");
                return;
            }
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
            dialog.setPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            dialog.open();
        }
    }

    protected Collection<IProject> getSelectionProjects(IProject selectedProject) {
        return null;
    }

    protected IFrameworkCommand getSelectedCommand(IAction action, ISelection selection) {
        return null;
    }

    protected abstract GenericCommandWizard getCommandWizard(Collection<IProject> var1, IFrameworkCommand var2);
}

