/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;

public class PerspectiveMigrator {
    public IStatus migratePerspective(String oldPerspectiveId, String newPerspectiveId, IProgressMonitor monitor) {
        try {
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Migrating legacy perspectives", (int)3);
            IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            monitor.worked(1);
            IWorkbenchPage page = null;
            try {
                page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            }
            catch (NullPointerException nullPointerException) {}
            if (page != null) {
                if (page.getPerspective() == null || page.getPerspective().getId().equals(oldPerspectiveId)) {
                    IPerspectiveDescriptor newPerspective = registry.findPerspectiveWithId(newPerspectiveId);
                    page.setPerspective(newPerspective);
                    IPerspectiveDescriptor oldPerspective = registry.findPerspectiveWithId(oldPerspectiveId);
                    monitor.worked(1);
                    if (oldPerspective != null) {
                        page.closePerspective(oldPerspective, false, false);
                        registry.deletePerspective(oldPerspective);
                    }
                }
                if (page instanceof WorkbenchPage) {
                    try {
                        Method closePerspectiveMethod = WorkbenchPage.class.getDeclaredMethod("closePerspective", IPerspectiveDescriptor.class, String.class, Boolean.TYPE, Boolean.TYPE);
                        closePerspectiveMethod.invoke((Object)page, null, "com.springsource.sts.grails.perspective", true, false);
                    }
                    catch (Exception exception) {}
                }
            }
            monitor.worked(1);
            monitor.done();
            return new Status(0, "org.springsource.ide.eclipse.commons.frameworks.ui", "Migrate legacy perspectives.");
        }
        catch (Exception e) {
            return new Status(4, "org.springsource.ide.eclipse.commons.frameworks.ui", "Problem migrating legacy perspectives.", (Throwable)e);
        }
    }
}

