/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IIntroductionDefinition;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceDeclareParentAopTargetMethodNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ModelUtils;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class AdviceRootAopReferenceNode
implements IReferenceNode,
IRevealableReferenceNode {
    private List<IAopReference> reference;

    public AdviceRootAopReferenceNode(List<IAopReference> reference) {
        this(reference, false);
    }

    public AdviceRootAopReferenceNode(List<IAopReference> reference, boolean isBeanConfig) {
        this.reference = reference;
    }

    @Override
    public IReferenceNode[] getChildren() {
        ArrayList<AdviceDeclareParentAopTargetMethodNode> nodes = new ArrayList<AdviceDeclareParentAopTargetMethodNode>();
        for (IAopReference r : this.reference) {
            nodes.add(new AdviceDeclareParentAopTargetMethodNode(r));
        }
        return nodes.toArray(new IReferenceNode[nodes.size()]);
    }

    @Override
    public Image getImage() {
        IAopReference.ADVICE_TYPE type = this.reference.get(0).getAdviceType();
        if (type == IAopReference.ADVICE_TYPE.AFTER || type == IAopReference.ADVICE_TYPE.AFTER_RETURNING || type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.after_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.before_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.AROUND) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.around_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.introduction_obj.gif");
        }
        return null;
    }

    @Override
    public String getText() {
        IAopReference.ADVICE_TYPE type = this.reference.get(0).getAdviceType();
        String text = "";
        if (type == IAopReference.ADVICE_TYPE.AFTER) {
            text = String.valueOf(text) + "after()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_RETURNING) {
            text = String.valueOf(text) + "after-returning()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            text = String.valueOf(text) + "after-throwing()";
        } else if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            text = String.valueOf(text) + "before()";
        } else if (type == IAopReference.ADVICE_TYPE.AROUND) {
            text = String.valueOf(text) + "around()";
        } else if (type == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            text = String.valueOf(text) + "declare parents: implements " + ((IIntroductionDefinition)this.reference.get(0).getDefinition()).getImplInterfaceName();
        }
        text = String.valueOf(text) + " <";
        text = String.valueOf(text) + this.reference.get(0).getDefinition().getAspectName();
        text = String.valueOf(text) + "> - ";
        text = String.valueOf(text) + ModelUtils.getFilePath(this.getResource());
        return text;
    }

    public List<IAopReference> getReference() {
        return this.reference;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void openAndReveal() {
        IResource resource = this.reference.get(0).getDefinition().getResource();
        SpringUIUtils.openInEditor((IFile)((IFile)resource), (int)this.reference.get(0).getDefinition().getAspectStartLineNumber());
    }

    @Override
    public int getLineNumber() {
        return this.reference.get(0).getDefinition().getAspectStartLineNumber();
    }

    @Override
    public IResource getResource() {
        return this.reference.get(0).getResource();
    }

    @Override
    public Object getReferenceParticipant() {
        return this.reference.get(0).getDefinition();
    }
}

