/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.internal.validation;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.data.internal.validation.CompilationUnit;
import org.springframework.ide.eclipse.data.internal.validation.SpringDataValidationContext;
import org.springframework.ide.eclipse.data.jdt.core.RepositoryInformation;

public class InvalidParameterTypeRule
implements IValidationRule<CompilationUnit, SpringDataValidationContext> {
    public static final String PROBLEM_ID = "INVALID_PARAMETER_TYPE";
    public static final String PROPERTY_TYPE_ATTR = "PROPERTY_TYPE_ATTR";
    public static final String PROPERTY_TYPE_PACKAGE_ATTR = "PROPERTY_TYPE_PACKAGE_ATTR";

    public boolean supports(IModelElement element, IValidationContext context) {
        if (!(context instanceof SpringDataValidationContext)) {
            return false;
        }
        if (element instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)element;
            ITypeRoot typeRoot = cu.getTypeRoot();
            if (typeRoot == null) {
                return false;
            }
            IType type = typeRoot.findPrimaryType();
            if (type == null) {
                return false;
            }
            try {
                if (type == null || !type.isInterface() || type.isAnnotation()) {
                    return false;
                }
            }
            catch (JavaModelException e) {
                SpringCore.log((Throwable)e);
                return false;
            }
            if (!RepositoryInformation.isSpringDataRepository(type)) {
                return false;
            }
            RepositoryInformation information = new RepositoryInformation(type);
            Class<?> domainClass = information.getManagedDomainClass();
            return domainClass != null;
        }
        return false;
    }

    public void validate(CompilationUnit element, SpringDataValidationContext context, IProgressMonitor monitor) {
        ITypeRoot typeRoot = element.getTypeRoot();
        IType type = typeRoot.findPrimaryType();
        RepositoryInformation information = new RepositoryInformation(type);
        Class<?> domainClass = information.getManagedDomainClass();
        if (domainClass == null) {
            return;
        }
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    IMethod method = iMethodArray[n2];
                    String methodName = method.getElementName();
                    if (methodName.startsWith("findBy")) {
                        String propertyName = StringUtils.uncapitalize((String)methodName.substring("findBy".length()));
                        ILocalVariable[] params = method.getParameters();
                        if (params.length == 1) {
                            String paramTypeSignature = params[0].getTypeSignature();
                            Method propertyMethod = null;
                            try {
                                propertyMethod = domainClass.getMethod("get" + StringUtils.capitalize((String)propertyName), new Class[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                break block11;
                            }
                            if (propertyMethod != null) {
                                Class<?> propertyReturnType = propertyMethod.getReturnType();
                                String propertySimpleType = propertyReturnType.getSimpleName();
                                String paramSimpleType = Signature.getSignatureSimpleName((String)paramTypeSignature);
                                if (propertySimpleType != null && !propertySimpleType.equals(paramSimpleType)) {
                                    element.setElementSourceLocation((IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)params[0]));
                                    ISourceRange paramSourceRange = params[0].getSourceRange();
                                    ValidationProblemAttribute start = new ValidationProblemAttribute("charStart", (Object)paramSourceRange.getOffset());
                                    ValidationProblemAttribute end = new ValidationProblemAttribute("charEnd", (Object)(paramSourceRange.getOffset() + paramSourceRange.getLength()));
                                    ValidationProblemAttribute problemId = new ValidationProblemAttribute("org.eclipse.core.resources.problemmarker", (Object)PROBLEM_ID);
                                    ValidationProblemAttribute propertyType = new ValidationProblemAttribute(PROPERTY_TYPE_ATTR, (Object)propertyReturnType.getSimpleName());
                                    String packageName = propertyReturnType.getPackage() != null ? propertyReturnType.getPackage().getName() : "";
                                    ValidationProblemAttribute propertyTypePackage = new ValidationProblemAttribute(PROPERTY_TYPE_PACKAGE_ATTR, (Object)packageName);
                                    context.warning((IResourceModelElement)element, "SpringDataProbleMarker", "Parameter type (" + paramSimpleType + ") does not match domain class property definition (" + propertySimpleType + ").", new ValidationProblemAttribute[]{start, end, problemId, propertyType, propertyTypePackage});
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
        }
        catch (SecurityException e) {
            SpringCore.log((Throwable)e);
        }
    }
}

