/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.springsource.ide.eclipse.commons.completions.CompletionsActivator;

public class JDTContentAssistPrefsHelper {
    private static final String JAR_TYPE_SEARCH_CATEGORY_ID = "org.springsource.ide.eclipse.commons.completions.externalTypesProposalCategory";

    public static void disableJarTypeSearch() {
        try {
            String[] _excluded = PreferenceConstants.getExcludedCompletionProposalCategories();
            LinkedHashSet<String> excluded = new LinkedHashSet<String>();
            if (_excluded != null) {
                excluded.addAll(Arrays.asList(_excluded));
            }
            excluded.add(JAR_TYPE_SEARCH_CATEGORY_ID);
            PreferenceConstants.setExcludedCompletionProposalCategories((String[])excluded.toArray(new String[excluded.size()]));
            Map<String, Integer> ranks = JDTContentAssistPrefsHelper.getCompletionProposalCategoryOrder();
            Integer existingRank = ranks.get(JAR_TYPE_SEARCH_CATEGORY_ID);
            if (existingRank != null) {
                if (existingRank >= 65535) {
                    return;
                }
                ranks.put(JAR_TYPE_SEARCH_CATEGORY_ID, 65535 + existingRank);
            } else {
                ranks.put(JAR_TYPE_SEARCH_CATEGORY_ID, 65635);
            }
            JDTContentAssistPrefsHelper.setCompletionProposalCategoryOrder(ranks);
        }
        catch (Exception e) {
            CompletionsActivator.log(e);
        }
    }

    private static Map<String, Integer> getCompletionProposalCategoryOrder() {
        String encodedPreference = PreferenceConstants.getPreference((String)"content_assist_category_order", null);
        StringTokenizer tokenizer = new StringTokenizer(encodedPreference, "\u0000");
        int count = tokenizer.countTokens();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int i = 0;
        while (i < count) {
            String pair = tokenizer.nextToken();
            String[] pieces = pair.split(":");
            result.put(pieces[0], Integer.parseInt(pieces[1]));
            ++i;
        }
        return result;
    }

    public static void setCompletionProposalCategoryOrder(Map<String, Integer> ranks) {
        Assert.isLegal((ranks != null ? 1 : 0) != 0);
        StringBuffer buf = new StringBuffer(50 * ranks.size());
        for (Map.Entry<String, Integer> pair : ranks.entrySet()) {
            buf.append(String.valueOf(pair.getKey()) + ":" + pair.getValue());
            buf.append('\u0000');
        }
        PreferenceConstants.getPreferenceStore().setValue("content_assist_category_order", buf.toString());
        CompletionProposalComputerRegistry.getDefault().reload();
    }
}

