/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.constructors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.springsource.ide.eclipse.commons.completions.CompletionsActivator;
import org.springsource.ide.eclipse.commons.completions.constructors.ConstructorCompletionEngine;

public class NoPrefixConstructorProposalComputer
implements IJavaCompletionProposalComputer {
    private static final String NEW_KEYWORD = "new";
    private static final long JAVA_CODE_ASSIST_TIMEOUT = Long.getLong("org.eclipse.jdt.ui.codeAssistTimeout", 5000L);

    public void sessionStarted() {
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext jdtContext = (JavaContentAssistInvocationContext)context;
            try {
                String prefix = jdtContext.computeIdentifierPrefix().toString();
                if (prefix.isEmpty() && this.isNewKeywordPreceeding(jdtContext) && jdtContext.getExpectedType() != null) {
                    ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                    proposals.addAll(Arrays.asList(this.doComputeCompletionProposals(jdtContext, NoPrefixConstructorProposalComputer.createTimeoutProgressMonitor(JAVA_CODE_ASSIST_TIMEOUT))));
                    return proposals;
                }
            }
            catch (BadLocationException e) {
                CompletionsActivator.log(e);
            }
        }
        return Collections.emptyList();
    }

    private boolean isNewKeywordPreceeding(JavaContentAssistInvocationContext context) {
        block5: {
            IDocument document = context.getDocument();
            if (document == null) {
                return false;
            }
            int end = this.skipWhiteSpaceBackward(document, context.getInvocationOffset());
            if (end >= NEW_KEYWORD.length() - 1) {
                block6: {
                    try {
                        if (!NEW_KEYWORD.equals(document.get(end - 2, NEW_KEYWORD.length()))) break block5;
                        if ((end -= 2) != 0) break block6;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                return !Character.isJavaIdentifierPart(document.getChar(end - 1));
            }
        }
        return false;
    }

    private int skipWhiteSpaceBackward(IDocument document, int end) {
        int start = end;
        while (--start >= 0) {
            try {
                if (!Character.isJavaIdentifierPart(document.getChar(start))) continue;
                break;
            }
            catch (BadLocationException badLocationException) {}
        }
        return start;
    }

    private IJavaCompletionProposal[] doComputeCompletionProposals(JavaContentAssistInvocationContext context, IProgressMonitor monitor) {
        CompletionProposalCollector collector = this.createCollector(context);
        collector.setIgnored(27, false);
        collector.setIgnored(26, false);
        collector.setAllowsRequiredProposals(26, 9, true);
        collector.setAllowsRequiredProposals(27, 9, true);
        try {
            JavaProject javaProject = (JavaProject)context.getProject();
            SearchableEnvironment searchableEnvironment = new SearchableEnvironment(javaProject, new org.eclipse.jdt.core.ICompilationUnit[]{context.getCompilationUnit()});
            ICompilationUnit cu = (ICompilationUnit)context.getCompilationUnit();
            ConstructorCompletionEngine engine = new ConstructorCompletionEngine(cu, (CompletionRequestor)collector, searchableEnvironment, javaProject, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, monitor);
            engine.complete(cu, context.getInvocationOffset(), null, context.getExpectedType());
        }
        catch (JavaModelException e) {
            CompletionsActivator.log(e);
        }
        catch (OperationCanceledException e) {
            CompletionsActivator.log((IStatus)new Status(2, "org.springsource.ide.eclipse.commons.completions", "Constructor completion proposal timed out", (Throwable)e));
        }
        return collector.getJavaCompletionProposals();
    }

    private CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            return new FillArgumentNamesCompletionProposalCollector(context);
        }
        return new CompletionProposalCollector(context.getCompilationUnit(), true);
    }

    private static IProgressMonitor createTimeoutProgressMonitor(final long timeout) {
        return new IProgressMonitor(){
            private long fEndTime;

            public void beginTask(String name, int totalWork) {
                this.fEndTime = System.currentTimeMillis() + timeout;
            }

            public boolean isCanceled() {
                return this.fEndTime <= System.currentTimeMillis();
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        };
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

