/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.blueprint;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.ide.eclipse.osgi.blueprint.TypeConverterBeanDefinitionParser;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintParser;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintReferenceBeanDefinitionParser;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintReferenceListBeanDefinitionParser;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintServiceDefinitionParser;
import org.springframework.ide.eclipse.osgi.blueprint.internal.ParsingUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class BlueprintBeanDefinitionParser
implements BeanDefinitionParser {
    static final String BLUEPRINT = "blueprint";
    private static final String DESCRIPTION = "description";
    private static final String BEAN = "bean";
    static final String REFERENCE = "reference";
    static final String SERVICE = "service";
    static final String REFERENCE_LIST = "reference-list";

    BlueprintBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element componentsRootElement, ParserContext parserContext) {
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        delegate.initDefaults(componentsRootElement);
        NodeList nl = componentsRootElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element) {
                Element ele = (Element)node;
                String namespaceUri = ele.getNamespaceURI();
                if (delegate.isDefaultNamespace(namespaceUri)) {
                    BeanDefinitionHolder holder = delegate.parseBeanDefinitionElement(ele);
                    ParsingUtils.decorateAndRegister(ele, holder, parserContext);
                } else if ("http://www.osgi.org/xmlns/blueprint/v1.0.0".equals(namespaceUri)) {
                    this.parseTopLevelElement(ele, parserContext);
                } else {
                    delegate.parseCustomElement(ele);
                }
            }
            ++i;
        }
        return null;
    }

    protected void parseTopLevelElement(Element ele, ParserContext parserContext) {
        if (!DomUtils.nodeNameEquals((Node)ele, (String)DESCRIPTION)) {
            if (DomUtils.nodeNameEquals((Node)ele, (String)BEAN)) {
                this.parseComponentElement(ele, parserContext);
            } else if (DomUtils.nodeNameEquals((Node)ele, (String)REFERENCE)) {
                this.parseReferenceElement(ele, parserContext);
            } else if (DomUtils.nodeNameEquals((Node)ele, (String)SERVICE)) {
                this.parseServiceElement(ele, parserContext);
            } else if (DomUtils.nodeNameEquals((Node)ele, (String)REFERENCE_LIST)) {
                this.parseListElement(ele, parserContext);
            } else if (DomUtils.nodeNameEquals((Node)ele, (String)"type-converters")) {
                this.parseConvertersElement(ele, parserContext);
            } else {
                throw new IllegalArgumentException("Unknown element " + ele);
            }
        }
    }

    protected void parseComponentElement(Element ele, ParserContext parserContext) {
        BeanDefinitionHolder holder = new BlueprintParser().parseAsHolder(ele, parserContext);
        ParsingUtils.decorateAndRegister(ele, holder, parserContext);
    }

    protected void parseConvertersElement(Element ele, ParserContext parserContext) {
        TypeConverterBeanDefinitionParser parser = new TypeConverterBeanDefinitionParser();
        parser.parse(ele, parserContext);
    }

    private void parseReferenceElement(Element ele, ParserContext parserContext) {
        BlueprintReferenceBeanDefinitionParser parser = new BlueprintReferenceBeanDefinitionParser();
        parser.parse(ele, parserContext);
    }

    private void parseServiceElement(Element ele, ParserContext parserContext) {
        BlueprintServiceDefinitionParser parser = new BlueprintServiceDefinitionParser();
        parser.parse(ele, parserContext);
    }

    private void parseListElement(Element ele, ParserContext parserContext) {
        BlueprintReferenceListBeanDefinitionParser parser = new BlueprintReferenceListBeanDefinitionParser();
        parser.parse(ele, parserContext);
    }
}

