/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.blueprint.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintDefaultsDefinition;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintParser;
import org.springframework.ide.eclipse.osgi.blueprint.internal.ParsingUtils;
import org.springframework.ide.eclipse.osgi.blueprint.internal.jaxb.TautoExportModes;
import org.springframework.ide.eclipse.osgi.blueprint.internal.util.AttributeCallback;
import org.springframework.ide.eclipse.osgi.blueprint.internal.util.ParserUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BlueprintServiceDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String INTERFACES_ID = "interfaces";
    private static final String INTERFACE = "interface";
    private static final String PROPS_ID = "service-properties";
    private static final String LISTENER = "registration-listener";
    private static final String REF = "ref";
    private static final String AUTOEXPORT = "auto-export";
    private static final String INTERFACES = "interfaces";
    private static final String DISABLED = "disabled";

    protected Class<?> getBeanClass(Element element) {
        return null;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(AUTOEXPORT) && !DISABLED.equals(element.getAttribute(AUTOEXPORT).trim())) {
            if (element.hasAttribute(INTERFACE)) {
                parserContext.getReaderContext().error("either 'auto-export' or 'interface' attribute has be specified but not both", (Object)element);
            }
            if (DomUtils.getChildElementByTagName((Element)element, (String)"interfaces") != null) {
                parserContext.getReaderContext().error("either 'auto-export' attribute or <intefaces> sub-element has be specified but not both", (Object)element);
            }
        }
        builder.setRole(2);
        builder.getRawBeanDefinition().setSynthetic(true);
        builder.getRawBeanDefinition().setFactoryBeanName("internal");
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        BlueprintDefaultsDefinition defaults = this.resolveDefaults(element.getOwnerDocument(), parserContext);
        ServiceAttributeCallback callback = new ServiceAttributeCallback();
        this.parseAttributes(element, builder, new AttributeCallback[]{callback}, defaults);
        Object target = null;
        if (element.hasAttribute(REF)) {
            target = new RuntimeBeanReference(element.getAttribute(REF));
        }
        NodeList nl = element.getChildNodes();
        ManagedList listeners = new ManagedList();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element) {
                Element subElement = (Element)node;
                String name = subElement.getLocalName();
                if (!this.parseInterfaces(element, subElement, parserContext, builder) && !this.parseServiceProperties(element, subElement, parserContext, builder)) {
                    if (LISTENER.equals(name)) {
                        BeanDefinition listenerDef = this.parseListener(parserContext, subElement, builder);
                        listeners.add((Object)listenerDef);
                    } else if ("description".equals(name)) {
                        builder.getRawBeanDefinition().setDescription(subElement.getTextContent());
                    } else {
                        target = this.parseBeanReference(element, subElement, parserContext, builder);
                    }
                }
            }
            ++i;
        }
        if (target instanceof RuntimeBeanReference) {
            builder.addPropertyValue(REF, (Object)target.getBeanName());
        } else {
            builder.addPropertyValue("bean", target);
        }
        builder.addPropertyValue("registrationListener", (Object)listeners);
    }

    private Object parseBeanReference(Element parent, Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (parent.hasAttribute(REF)) {
            parserContext.getReaderContext().error("nested bean definition/reference cannot be used when attribute 'ref' is specified", (Object)parent);
        }
        return this.parsePropertySubElement(parserContext, element, (BeanDefinition)builder.getRawBeanDefinition());
    }

    private void parseAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback[] callbacks, BlueprintDefaultsDefinition defaults) {
        ParserUtils.parseCustomAttributes(element, builder, callbacks);
    }

    private boolean parseServiceProperties(Element parent, Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String name = element.getLocalName();
        if (PROPS_ID.equals(name)) {
            Object props = null;
            String ref = element.getAttribute(REF).trim();
            boolean hasRef = StringUtils.hasText((String)ref);
            if (DomUtils.getChildElementsByTagName((Element)element, (String)"entry").size() > 0) {
                if (hasRef) {
                    parserContext.getReaderContext().error("Nested service properties definition cannot be used when attribute 'ref' is specified", (Object)element);
                } else {
                    props = this.parsePropertyMapElement(parserContext, element, (BeanDefinition)builder.getRawBeanDefinition());
                }
            }
            if (hasRef) {
                props = new RuntimeBeanReference(ref);
            }
            if (props != null) {
                builder.addPropertyValue(Conventions.attributeNameToPropertyName((String)PROPS_ID), props);
            } else {
                parserContext.getReaderContext().error("Invalid service property declaration", (Object)element);
            }
            return true;
        }
        return false;
    }

    private boolean parseInterfaces(Element parent, Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String name = element.getLocalName();
        if ("interfaces".equals(name)) {
            if (parent.hasAttribute(INTERFACE)) {
                parserContext.getReaderContext().error("either 'interface' attribute or <intefaces> sub-element has be specified", (Object)parent);
            }
            Set<?> interfaces = this.parsePropertySetElement(parserContext, element, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("interfaces", interfaces);
            return true;
        }
        return false;
    }

    private Map<?, ?> parsePropertyMapElement(ParserContext context, Element beanDef, BeanDefinition beanDefinition) {
        return BlueprintParser.parsePropertyMapElement(context, beanDef, beanDefinition);
    }

    private Set<?> parsePropertySetElement(ParserContext context, Element beanDef, BeanDefinition beanDefinition) {
        return BlueprintParser.parsePropertySetElement(context, beanDef, beanDefinition);
    }

    private Object parsePropertySubElement(ParserContext context, Element beanDef, BeanDefinition beanDefinition) {
        return BlueprintParser.parsePropertySubElement(context, beanDef, beanDefinition);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = ParsingUtils.resolveId(element, definition, parserContext, this.shouldGenerateId(), this.shouldGenerateIdAsFallback());
        this.validateServiceReferences(element, id, parserContext);
        return id;
    }

    private BlueprintDefaultsDefinition resolveDefaults(Document document, ParserContext parserContext) {
        return new BlueprintDefaultsDefinition(document, parserContext);
    }

    private BeanDefinition parseListener(ParserContext context, Element element, BeanDefinitionBuilder builder) {
        NodeList nl = element.getChildNodes();
        Object target = null;
        String targetName = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element) {
                Element nestedDefinition = (Element)node;
                if (element.hasAttribute(REF)) {
                    context.getReaderContext().error("nested bean declaration is not allowed if 'ref' attribute has been specified", (Object)nestedDefinition);
                }
                if ((target = this.parsePropertySubElement(context, nestedDefinition, (BeanDefinition)builder.getRawBeanDefinition())) instanceof RuntimeBeanReference) {
                    targetName = ((RuntimeBeanReference)target).getBeanName();
                }
            }
            ++i;
        }
        MutablePropertyValues vals = new MutablePropertyValues();
        NamedNodeMap attrs = element.getAttributes();
        int x = 0;
        while (x < attrs.getLength()) {
            Attr attribute = (Attr)attrs.item(x);
            String name = attribute.getLocalName();
            if (REF.equals(name)) {
                targetName = attribute.getValue();
            } else {
                vals.addPropertyValue(Conventions.attributeNameToPropertyName((String)name), (Object)attribute.getValue());
            }
            ++x;
        }
        RootBeanDefinition wrapperDef = new RootBeanDefinition();
        if (targetName != null) {
            vals.addPropertyValue(REF, targetName);
        } else {
            vals.addPropertyValue("bean", target);
        }
        wrapperDef.setPropertyValues(vals);
        return wrapperDef;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    private void validateServiceReferences(Element element, String serviceId, ParserContext parserContext) {
        String[] names;
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String[] stringArray = names = registry.getBeanDefinitionNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            BeanDefinition definition = registry.getBeanDefinition(name);
            Collection exporters = (Collection)definition.getAttribute("org.eclipse.gemini.blueprint.config.internal.reference.listener.ref.attr");
            if (exporters != null && exporters.contains(serviceId)) {
                parserContext.getReaderContext().error("Service exporter '" + serviceId + "' cannot be used as a reference listener by '" + name + "'", (Object)element);
            }
            ++n2;
        }
    }

    class ServiceAttributeCallback
    implements AttributeCallback {
        ServiceAttributeCallback() {
        }

        @Override
        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder bldr) {
            String name = attribute.getLocalName();
            if (BlueprintServiceDefinitionParser.INTERFACE.equals(name)) {
                bldr.addPropertyValue("interfaces", (Object)attribute.getValue());
                return false;
            }
            if (BlueprintServiceDefinitionParser.REF.equals(name)) {
                return false;
            }
            if (BlueprintServiceDefinitionParser.AUTOEXPORT.equals(name)) {
                bldr.addPropertyValue("autoExport", (Object)TautoExportModes.fromValue(attribute.getValue()));
                return false;
            }
            return true;
        }
    }
}

