/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.content.core;

import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;
import org.springsource.ide.eclipse.commons.content.core.ContentManager;
import org.springsource.ide.eclipse.commons.content.core.ContentPlugin;
import org.springsource.ide.eclipse.commons.core.HttpUtil;

public class TemplateDownloader {
    protected final ContentItem rootItem;
    private CountDownLatch resultLatch;
    private IProgressMonitor downloadMonitor;
    private IStatus timerStatus;

    protected TemplateDownloader(ContentItem rootItem) {
        this.rootItem = rootItem;
        this.timerStatus = Status.OK_STATUS;
    }

    protected IStatus getTimerStatus() {
        return this.timerStatus;
    }

    public void setTimerStatus(IStatus status) {
        this.timerStatus = status;
    }

    public void startCountdownTimer(IProgressMonitor monitor) {
        this.downloadMonitor = monitor;
        Job job = new Job("Downloading template"){

            protected IStatus run(IProgressMonitor aMonitor) {
                TemplateDownloader.this.timerStatus = Status.OK_STATUS;
                TemplateDownloader.this.resultLatch = new CountDownLatch(1);
                try {
                    try {
                        if (!TemplateDownloader.this.resultLatch.await(60L, TimeUnit.SECONDS)) {
                            String message = NLS.bind((String)"Download of {0} timed out, perhaps the network went down.", (Object)TemplateDownloader.this.rootItem.getRemoteDescriptor().getUrl());
                            TemplateDownloader.this.setTimerStatus((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message));
                        }
                    }
                    catch (InterruptedException e) {
                        System.err.println("Caught interrupted exception @@@ " + e);
                        TemplateDownloader.this.stopCountdownTimer();
                    }
                }
                finally {
                    TemplateDownloader.this.stopCountdownTimer();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void stopCountdownTimer() {
        this.resultLatch.countDown();
        if (this.downloadMonitor != null) {
            this.downloadMonitor.setCanceled(true);
        }
    }

    public IStatus downloadTemplate(IProgressMonitor monitor) {
        MultiStatus result = new MultiStatus("org.springsource.ide.eclipse.commons.content.core", 0, NLS.bind((String)"Download of ''{0}'' (''{1}'') failed", (Object)this.rootItem.getName(), (Object)this.rootItem.getId()), null);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        ContentManager manager = ContentPlugin.getDefault().getManager();
        try {
            try {
                List<ContentItem> dependencies = manager.getDependencies(this.rootItem);
                for (ContentItem item : dependencies) {
                    String url = item.getRemoteDescriptor().getUrl();
                    File baseDirectory = manager.getInstallDirectory();
                    File archiveFile = new File(baseDirectory, String.valueOf(item.getPathFromRemoteDescriptor()) + ".zip");
                    File directory = new File(baseDirectory, item.getPathFromRemoteDescriptor());
                    this.startCountdownTimer(monitor);
                    IStatus status = HttpUtil.download((String)url, (File)archiveFile, (File)directory, (IProgressMonitor)progress);
                    this.stopCountdownTimer();
                    result.add(status);
                }
                manager.refresh((IProgressMonitor)progress, false);
            }
            catch (OperationCanceledException e) {
                if (this.getTimerStatus().isOK()) {
                    throw e;
                }
                Status status = new Status(4, "org.springsource.ide.eclipse.commons.content.core", 0, NLS.bind((String)"Download ''{0}'' (''{1}'') timed out", (Object)this.rootItem.getName(), (Object)this.rootItem.getId()), (Throwable)e);
                progress.done();
                result.add(this.getTimerStatus());
                return status;
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.springsource.ide.eclipse.commons.content.core", 0, NLS.bind((String)"Failed to determine dependencies of ''{0}'' (''{1}'')", (Object)this.rootItem.getName(), (Object)this.rootItem.getId()), (Throwable)e);
                progress.done();
                result.add(this.getTimerStatus());
                return status;
            }
        }
        finally {
            progress.done();
            result.add(this.getTimerStatus());
        }
        return result;
    }
}

