/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.aspectj.lang.reflect.PerClauseKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanAspectDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AbstractAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AdviceAnnotationVisitor;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AspectAnnotationVisitor;
import org.springframework.ide.eclipse.aop.core.logging.AopLog;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.model.builder.IAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.model.builder.IDocumentFactory;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansList;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansTypedString;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.type.asm.CachingClassReaderFactory;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;
import org.springframework.util.StringUtils;

public class AnnotationAspectDefinitionBuilder
extends AbstractAspectDefinitionBuilder
implements IAspectDefinitionBuilder {
    private static final String AJC_MAGIC = "ajc$";
    private static final String PROXY_TARGET_CLASS = "proxyTargetClass";
    private static final String INCLUDE_PATTERNS = "includePatterns";
    private ClassReaderFactory classReaderFactory = null;

    @Override
    public void buildAspectDefinitions(List<IAspectDefinition> aspectInfos, IFile file, IProjectClassLoaderSupport classLoaderSupport, IDocumentFactory factory) {
        if (BeansCoreUtils.isBeansConfig((IResource)file, (boolean)true)) {
            IBeansConfig beansConfig = BeansCorePlugin.getModel().getConfig(file, true);
            this.parseAnnotationAspects(beansConfig, aspectInfos, classLoaderSupport);
        }
    }

    private void addAspectDefinition(IAspectDefinition info, List<IAspectDefinition> aspectInfos) {
        AopLog.log(4, info.toString());
        aspectInfos.add(info);
    }

    private void createAnnotationAspectDefinition(IBean bean, String id, String className, List<IAspectDefinition> aspectInfos) throws Throwable {
        ClassReader classReader = this.getClassReader(className);
        if (classReader == null) {
            return;
        }
        AdviceAnnotationVisitor v = new AdviceAnnotationVisitor(id, className, bean.getElementStartLine(), bean.getElementEndLine());
        classReader.accept((ClassVisitor)v, 0);
        List<IAspectDefinition> aspectDefinitions = v.getAspectDefinitions();
        for (IAspectDefinition def : aspectDefinitions) {
            def.setResource(bean.getElementResource());
            this.addAspectDefinition(def, aspectInfos);
        }
    }

    private ClassReader getClassReader(String className) {
        if (this.classReaderFactory == null) {
            this.classReaderFactory = new CachingClassReaderFactory();
        }
        try {
            return this.classReaderFactory.getClassReader(className);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void parseAnnotationAspectFromSingleBean(IBeansConfig beansConfig, IProjectClassLoaderSupport classLoaderSupport, final List<IAspectDefinition> aspectDefinitions, AspectJAutoProxyConfiguration configuration, final IBean bean) {
        final String id = bean.getElementName();
        final String className = BeansModelUtils.getBeanClass((IBean)bean, (IModelElement)beansConfig);
        if (className != null && configuration.isIncluded(id)) {
            try {
                classLoaderSupport.executeCallback(new IProjectClassLoaderSupport.IProjectClassLoaderAwareCallback(){

                    public void doWithActiveProjectClassLoader() throws Throwable {
                        if (AnnotationAspectDefinitionBuilder.this.validateAspect(className)) {
                            AnnotationAspectDefinitionBuilder.this.createAnnotationAspectDefinition(bean, id, className, aspectDefinitions);
                        }
                    }
                });
            }
            catch (Throwable e) {
                AopLog.log(4, Activator.getFormattedMessage("AspectDefinitionBuilder.exceptionOnNode", bean));
                Activator.log(e);
            }
        }
    }

    private void parseAnnotationAspects(IBeansConfig beansConfig, List<IAspectDefinition> aspectInfos, IProjectClassLoaderSupport classLoaderSupport) {
        AspectJAutoProxyConfiguration configuration = this.getAspectJAutoProxyConfiguration(beansConfig);
        if (!configuration.isAutoProxy()) {
            return;
        }
        ArrayList<IAspectDefinition> aspectDefinitions = new ArrayList<IAspectDefinition>();
        for (IBean bean : BeansModelUtils.getBeans((IModelElement)beansConfig)) {
            this.parseAnnotationAspectFromSingleBean(beansConfig, classLoaderSupport, aspectDefinitions, configuration, bean);
        }
        if (configuration.isProxyTargetClass()) {
            for (IAspectDefinition def : aspectDefinitions) {
                ((BeanAspectDefinition)def).setProxyTargetClass(configuration.isProxyTargetClass());
            }
        }
        aspectInfos.addAll(aspectDefinitions);
    }

    private AspectJAutoProxyConfiguration getAspectJAutoProxyConfiguration(IBeansConfig beansConfig) {
        AspectJAutoProxyConfiguration configuration = new AspectJAutoProxyConfiguration();
        this.getAspectJConfigurationForBeansConfig(beansConfig, configuration);
        for (IBeansConfigSet configSet : BeansModelUtils.getConfigSets((IModelElement)beansConfig)) {
            for (IBeansConfig config : configSet.getConfigs()) {
                if (config.equals(beansConfig)) continue;
                this.getAspectJConfigurationForBeansConfig(beansConfig, configuration);
            }
        }
        return configuration;
    }

    private void getAspectJConfigurationForBeansConfig(IBeansConfig beansConfig, AspectJAutoProxyConfiguration configuration) {
        IBean autoproxyBean = BeansModelUtils.getBean((String)"org.springframework.aop.config.internalAutoProxyCreator", (IModelElement)beansConfig);
        if (autoproxyBean != null) {
            IBeanProperty includes;
            String value;
            boolean proxyTargetClass;
            configuration.setAutoProxy(true);
            IBeanProperty targetProxyClassProperty = autoproxyBean.getProperty(PROXY_TARGET_CLASS);
            if (targetProxyClassProperty != null && targetProxyClassProperty.getValue() != null && (proxyTargetClass = Boolean.valueOf(value = ((BeansTypedString)targetProxyClassProperty.getValue()).getString()).booleanValue())) {
                configuration.setProxyTargetClass(proxyTargetClass);
            }
            if ((includes = autoproxyBean.getProperty(INCLUDE_PATTERNS)) != null && includes.getValue() != null) {
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                BeansList includesList = (BeansList)includes.getValue();
                List includePatterns = includesList.getList();
                for (Object includePattern : includePatterns) {
                    String pattern = ((BeansTypedString)includePattern).getString();
                    if (!StringUtils.hasText((String)pattern)) continue;
                    patterns.add(Pattern.compile(pattern));
                }
                configuration.setIncluldePatterns(patterns);
            }
        }
    }

    private boolean validateAspect(String className) throws Throwable {
        ClassReader classReader = this.getClassReader(className);
        if (classReader == null) {
            return false;
        }
        AspectAnnotationVisitor v = new AspectAnnotationVisitor();
        classReader.accept((ClassVisitor)v, 0);
        if (!v.getClassInfo().hasAspectAnnotation()) {
            return false;
        }
        for (String m : v.getClassInfo().getMethodNames()) {
            if (!m.startsWith(AJC_MAGIC)) continue;
            return false;
        }
        if (v.getClassInfo().getAspectAnnotation().getValue() != null) {
            if (v.getClassInfo().getAspectAnnotation().getValue().toUpperCase().equals(PerClauseKind.PERCFLOW.toString())) {
                return false;
            }
            if (v.getClassInfo().getAspectAnnotation().getValue().toUpperCase().toString().equals(PerClauseKind.PERCFLOWBELOW.toString())) {
                return false;
            }
        }
        if (v.getClassInfo().getSuperType() != null) {
            classReader = this.getClassReader(v.getClassInfo().getSuperType());
            if (classReader == null) {
                return false;
            }
            AspectAnnotationVisitor sv = new AspectAnnotationVisitor();
            classReader.accept((ClassVisitor)sv, 0);
            if (sv.getClassInfo().getAspectAnnotation() != null && (sv.getClassInfo().getModifier() & 0x400) == 0) {
                return false;
            }
        }
        return true;
    }

    class AspectJAutoProxyConfiguration {
        private List<Pattern> includePatterns;
        private boolean proxyTargetClass;
        private boolean isAutoProxy = false;

        AspectJAutoProxyConfiguration() {
        }

        public void setProxyTargetClass(boolean proxyTargetClass) {
            this.proxyTargetClass = proxyTargetClass;
        }

        public boolean isProxyTargetClass() {
            return this.proxyTargetClass;
        }

        public void setAutoProxy(boolean autoProxy) {
            this.isAutoProxy = autoProxy;
        }

        public boolean isAutoProxy() {
            return this.isAutoProxy;
        }

        public void setIncluldePatterns(List<Pattern> includePatterns) {
            this.includePatterns = includePatterns;
        }

        public boolean isIncluded(String beanName) {
            if (this.includePatterns == null) {
                return true;
            }
            if (this.includePatterns != null && this.includePatterns.size() == 0) {
                return false;
            }
            for (Pattern pattern : this.includePatterns) {
                if (beanName == null) {
                    return false;
                }
                if (!pattern.matcher(beanName).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

