/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.ide.eclipse.core.type.asm.EmptyAnnotationVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyMethodVisitor;

public class AspectAnnotationVisitor
extends ClassVisitor {
    private ClassInfo classInfo = new ClassInfo();
    private static final String ASPECT_ANNOTATION_DESC = Type.getDescriptor(Aspect.class);
    private static final String OBJECT_CLASS = Type.getInternalName(Object.class);

    public AspectAnnotationVisitor() {
        super(327680);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classInfo.setModifier(access);
        if (!OBJECT_CLASS.equals(superName)) {
            this.classInfo.setSuperType(superName);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible && ASPECT_ANNOTATION_DESC.equals(desc)) {
            this.classInfo.setAspectAnnotation(new AspectAnnotation());
            return new EmptyAnnotationVisitor(){

                public void visit(String name, Object value) {
                    if ("value".equals(name) && AspectAnnotationVisitor.this.classInfo.hasAspectAnnotation()) {
                        AspectAnnotationVisitor.this.classInfo.getAspectAnnotation().setValue((String)value);
                    }
                }
            };
        }
        return new EmptyAnnotationVisitor();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.classInfo.getMethodNames().add(name);
        return new EmptyMethodVisitor();
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public static class AspectAnnotation {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class ClassInfo {
        private int modifier;
        private String superType = null;
        private List<String> methodNames = new ArrayList<String>();
        private AspectAnnotation aspectAnnotation;

        public AspectAnnotation getAspectAnnotation() {
            return this.aspectAnnotation;
        }

        public void setAspectAnnotation(AspectAnnotation aspectAnnotation) {
            this.aspectAnnotation = aspectAnnotation;
        }

        public String getSuperType() {
            return this.superType;
        }

        public void setSuperType(String superType) {
            this.superType = superType;
        }

        public List<String> getMethodNames() {
            return this.methodNames;
        }

        public void setMethodNames(List<String> methodNames) {
            this.methodNames = methodNames;
        }

        public boolean hasAspectAnnotation() {
            return this.aspectAnnotation != null;
        }

        public int getModifier() {
            return this.modifier;
        }

        public void setModifier(int modifier) {
            this.modifier = modifier;
        }
    }
}

