/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;

public final class DirectProcessor<T>
extends FluxProcessor<T, T>
implements Receiver,
MultiProducer {
    private static final DirectProcessorSubscription[] EMPTY = new DirectProcessorSubscription[0];
    private static final DirectProcessorSubscription[] TERMINATED = new DirectProcessorSubscription[0];
    private volatile DirectProcessorSubscription<T>[] subscribers = EMPTY;
    private static final AtomicReferenceFieldUpdater<DirectProcessor, DirectProcessorSubscription[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(DirectProcessor.class, DirectProcessorSubscription[].class, "subscribers");
    Throwable error;

    public static <E> DirectProcessor<E> create() {
        return new DirectProcessor();
    }

    DirectProcessor() {
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    public void onSubscribe(Subscription s) {
        Objects.requireNonNull(s, "s");
        if (this.subscribers != TERMINATED) {
            s.request(Long.MAX_VALUE);
        } else {
            s.cancel();
        }
    }

    public void onNext(T t) {
        Objects.requireNonNull(t, "t");
        for (DirectProcessorSubscription<T> s : this.subscribers) {
            s.onNext(t);
        }
    }

    public void onError(Throwable t) {
        Objects.requireNonNull(t, "t");
        this.error = t;
        for (DirectProcessorSubscription s : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s.onError(t);
        }
    }

    public void onComplete() {
        for (DirectProcessorSubscription s : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s.onComplete();
        }
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Objects.requireNonNull(s, "s");
        DirectProcessorSubscription<? super T> p = new DirectProcessorSubscription<T>(s, this);
        s.onSubscribe(p);
        if (this.add(p)) {
            if (p.cancelled) {
                this.remove(p);
            }
        } else {
            Throwable e = this.error;
            if (e != null) {
                s.onError(e);
            } else {
                s.onComplete();
            }
        }
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public boolean isTerminated() {
        return TERMINATED == this.subscribers;
    }

    @Override
    public Iterator<?> downstreams() {
        return Arrays.asList(this.subscribers).iterator();
    }

    @Override
    public long downstreamCount() {
        return this.subscribers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(DirectProcessorSubscription<T> s) {
        DirectProcessorSubscription<T>[] a = this.subscribers;
        if (a == TERMINATED) {
            return false;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers;
            if (a == TERMINATED) {
                return false;
            }
            int len = a.length;
            DirectProcessorSubscription[] b = new DirectProcessorSubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = s;
            this.subscribers = b;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectProcessorSubscription<T> s) {
        DirectProcessorSubscription<T>[] a = this.subscribers;
        if (a == TERMINATED || a == EMPTY) {
            return;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers;
            if (a == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != s) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                this.subscribers = EMPTY;
                return;
            }
            DirectProcessorSubscription[] b = new DirectProcessorSubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
            this.subscribers = b;
        }
    }

    @Override
    public boolean hasDownstreams() {
        DirectProcessorSubscription<T>[] s = this.subscribers;
        return s != EMPTY && s != TERMINATED;
    }

    public boolean hasCompleted() {
        return this.subscribers == TERMINATED && this.error == null;
    }

    public boolean hasError() {
        return this.subscribers == TERMINATED && this.error != null;
    }

    @Override
    public Throwable getError() {
        if (this.subscribers == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    public Object upstream() {
        return null;
    }

    static final class DirectProcessorSubscription<T>
    implements Subscription,
    Receiver,
    Producer,
    Trackable {
        final Subscriber<? super T> actual;
        final DirectProcessor<T> parent;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<DirectProcessorSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(DirectProcessorSubscription.class, "requested");

        public DirectProcessorSubscription(Subscriber<? super T> actual, DirectProcessor<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        public Subscriber<? super T> downstream() {
            return this.actual;
        }

        @Override
        public long requestedFromDownstream() {
            return 0L;
        }

        public Processor<T, T> upstream() {
            return this.parent;
        }

        void onNext(T value) {
            if (this.requested != 0L) {
                this.actual.onNext(value);
                if (this.requested != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return;
            }
            this.parent.remove(this);
            this.actual.onError((Throwable)new IllegalStateException("Can't deliver value due to lack of requests"));
        }

        void onError(Throwable e) {
            this.actual.onError(e);
        }

        void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.parent.isStarted();
        }

        @Override
        public boolean isTerminated() {
            return this.parent.isTerminated();
        }
    }
}

