/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;

final class FluxAutoConnectFuseable<T>
extends Flux<T>
implements Receiver,
Fuseable {
    final ConnectableFlux<? extends T> source;
    final Consumer<? super Cancellation> cancelSupport;
    volatile int remaining;
    static final AtomicIntegerFieldUpdater<FluxAutoConnectFuseable> REMAINING = AtomicIntegerFieldUpdater.newUpdater(FluxAutoConnectFuseable.class, "remaining");

    public FluxAutoConnectFuseable(ConnectableFlux<? extends T> source, int n, Consumer<? super Cancellation> cancelSupport) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > required but it was " + n);
        }
        this.source = Objects.requireNonNull(source, "source");
        this.cancelSupport = Objects.requireNonNull(cancelSupport, "cancelSupport");
        REMAINING.lazySet(this, n);
    }

    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(s);
        if (this.remaining > 0 && REMAINING.decrementAndGet(this) == 0) {
            this.source.connect(this.cancelSupport);
        }
    }

    @Override
    public Object upstream() {
        return this.source;
    }
}

