/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxBuffer<T, C extends Collection<? super T>>
extends FluxSource<T, C> {
    final int size;
    final int skip;
    final Supplier<C> bufferSupplier;

    public FluxBuffer(Publisher<? extends T> source, int size, Supplier<C> bufferSupplier) {
        this(source, size, size, bufferSupplier);
    }

    public FluxBuffer(Publisher<? extends T> source, int size, int skip, Supplier<C> bufferSupplier) {
        super(source);
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        if (skip <= 0) {
            throw new IllegalArgumentException("skip > 0 required but it was " + size);
        }
        this.size = size;
        this.skip = skip;
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super C> s) {
        if (this.size == this.skip) {
            this.source.subscribe(new BufferExactSubscriber(s, this.size, this.bufferSupplier));
        } else if (this.skip > this.size) {
            this.source.subscribe(new BufferSkipSubscriber(s, this.size, this.skip, this.bufferSupplier));
        } else {
            this.source.subscribe(new BufferOverlappingSubscriber(s, this.size, this.skip, this.bufferSupplier));
        }
    }

    static final class BufferOverlappingSubscriber<T, C extends Collection<? super T>>
    implements Subscriber<T>,
    Subscription,
    Receiver,
    BooleanSupplier,
    Producer,
    Trackable,
    Loopback {
        final Subscriber<? super C> actual;
        final Supplier<C> bufferSupplier;
        final int size;
        final int skip;
        final ArrayDeque<C> buffers;
        Subscription s;
        boolean done;
        long index;
        volatile boolean cancelled;
        volatile int once;
        static final AtomicIntegerFieldUpdater<BufferOverlappingSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(BufferOverlappingSubscriber.class, "once");
        volatile long requested;
        static final AtomicLongFieldUpdater<BufferOverlappingSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferOverlappingSubscriber.class, "requested");

        public BufferOverlappingSubscriber(Subscriber<? super C> actual, int size, int skip, Supplier<C> bufferSupplier) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new ArrayDeque();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        public void request(long n) {
            if (!Operators.validate(n)) {
                return;
            }
            if (DrainUtils.postCompleteRequest(n, this.actual, this.buffers, REQUESTED, this, this)) {
                return;
            }
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                long u = Operators.multiplyCap(this.skip, n - 1L);
                long r = Operators.addCap(this.size, u);
                this.s.request(r);
            } else {
                long r = Operators.multiplyCap(this.skip, n);
                this.s.request(r);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            Collection b;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            ArrayDeque<C> bs = this.buffers;
            long i = this.index;
            if (i % (long)this.skip == 0L) {
                try {
                    b = (Collection)this.bufferSupplier.get();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (b == null) {
                    this.cancel();
                    this.onError(new NullPointerException("The bufferSupplier returned a null buffer"));
                    return;
                }
                bs.offer(b);
            }
            if ((b = (Collection)bs.peek()) != null && b.size() + 1 == this.size) {
                bs.poll();
                b.add(t);
                this.actual.onNext((Object)b);
                if (this.requested != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
            }
            for (Collection b0 : bs) {
                b0.add(t);
            }
            this.index = i + 1L;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.buffers.clear();
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DrainUtils.postComplete(this.actual, this.buffers, REQUESTED, this, this);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.cancelled && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public long getPending() {
            return this.buffers.size() * this.size;
        }

        @Override
        public long getCapacity() {
            return Long.MAX_VALUE;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public Object connectedInput() {
            return this.bufferSupplier;
        }

        @Override
        public Object connectedOutput() {
            return this.buffers;
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }

    static final class BufferSkipSubscriber<T, C extends Collection<? super T>>
    implements Subscriber<T>,
    Subscription,
    Receiver,
    Producer,
    Loopback,
    Trackable {
        final Subscriber<? super C> actual;
        final Supplier<C> bufferSupplier;
        final int size;
        final int skip;
        C buffer;
        Subscription s;
        boolean done;
        long index;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BufferSkipSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(BufferSkipSubscriber.class, "wip");

        public BufferSkipSubscriber(Subscriber<? super C> actual, int size, int skip, Supplier<C> bufferSupplier) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
        }

        public void request(long n) {
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                long u = Operators.multiplyCap(n, this.size);
                long v = Operators.multiplyCap(this.skip - this.size, n - 1L);
                this.s.request(Operators.addCap(u, v));
            } else {
                this.s.request(Operators.multiplyCap(this.skip, n));
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            Object b = this.buffer;
            long i = this.index;
            if (i % (long)this.skip == 0L) {
                try {
                    b = (Collection)this.bufferSupplier.get();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (b == null) {
                    this.cancel();
                    this.onError(new NullPointerException("The bufferSupplier returned a null buffer"));
                    return;
                }
                this.buffer = b;
            }
            if (b != null) {
                b.add(t);
                if (b.size() == this.size) {
                    this.buffer = null;
                    this.actual.onNext(b);
                }
            }
            this.index = i + 1L;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.buffer = null;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b = this.buffer;
            this.buffer = null;
            if (b != null) {
                this.actual.onNext(b);
            }
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.bufferSupplier;
        }

        @Override
        public Object connectedOutput() {
            return this.buffer;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public long getPending() {
            C b = this.buffer;
            return b != null ? (long)b.size() : 0L;
        }

        @Override
        public long getCapacity() {
            return this.size;
        }
    }

    static final class BufferExactSubscriber<T, C extends Collection<? super T>>
    implements Subscriber<T>,
    Subscription,
    Receiver,
    Producer,
    Loopback,
    Trackable {
        final Subscriber<? super C> actual;
        final Supplier<C> bufferSupplier;
        final int size;
        C buffer;
        Subscription s;
        boolean done;

        public BufferExactSubscriber(Subscriber<? super C> actual, int size, Supplier<C> bufferSupplier) {
            this.actual = actual;
            this.size = size;
            this.bufferSupplier = bufferSupplier;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                this.s.request(Operators.multiplyCap(n, this.size));
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            Object b = this.buffer;
            if (b == null) {
                try {
                    b = (Collection)this.bufferSupplier.get();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (b == null) {
                    this.cancel();
                    this.onError(new NullPointerException("The bufferSupplier returned a null buffer"));
                    return;
                }
                this.buffer = b;
            }
            b.add(t);
            if (b.size() == this.size) {
                this.buffer = null;
                this.actual.onNext(b);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b = this.buffer;
            if (b != null && !b.isEmpty()) {
                this.actual.onNext(b);
            }
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.bufferSupplier;
        }

        @Override
        public Object connectedOutput() {
            return this.buffer;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public long getPending() {
            C b = this.buffer;
            return b != null ? (long)b.size() : 0L;
        }

        @Override
        public long getCapacity() {
            return this.size;
        }
    }
}

