/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxConcatMap<T, R>
extends FluxSource<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final Supplier<? extends Queue<T>> queueSupplier;
    final int prefetch;
    final ErrorMode errorMode;

    public static <T, R> Subscriber<T> subscriber(Subscriber<? super R> s, Function<? super T, ? extends Publisher<? extends R>> mapper, Supplier<? extends Queue<T>> queueSupplier, int prefetch, ErrorMode errorMode) {
        FluxConcatMapSupport parent;
        switch (errorMode) {
            case BOUNDARY: {
                parent = new ConcatMapDelayed<T, R>(s, mapper, queueSupplier, prefetch, false);
                break;
            }
            case END: {
                parent = new ConcatMapDelayed<T, R>(s, mapper, queueSupplier, prefetch, true);
                break;
            }
            default: {
                parent = new ConcatMapImmediate<T, R>(s, mapper, queueSupplier, prefetch);
            }
        }
        return parent;
    }

    public FluxConcatMap(Publisher<? extends T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, Supplier<? extends Queue<T>> queueSupplier, int prefetch, ErrorMode errorMode) {
        super(source);
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
        this.prefetch = prefetch;
        this.errorMode = Objects.requireNonNull(errorMode, "errorMode");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        FluxConcatMapSupport parent;
        if (FluxFlatMap.trySubscribeScalarMap(this.source, s, this.mapper, false)) {
            return;
        }
        switch (this.errorMode) {
            case BOUNDARY: {
                parent = new ConcatMapDelayed<T, R>(s, this.mapper, this.queueSupplier, this.prefetch, false);
                break;
            }
            case END: {
                parent = new ConcatMapDelayed<T, R>(s, this.mapper, this.queueSupplier, this.prefetch, true);
                break;
            }
            default: {
                parent = new ConcatMapImmediate<T, R>(s, this.mapper, this.queueSupplier, this.prefetch);
            }
        }
        this.source.subscribe(parent);
    }

    static final class ConcatMapInner<R>
    extends Operators.MultiSubscriptionSubscriber<R, R> {
        final FluxConcatMapSupport<R> parent;
        long produced;

        public ConcatMapInner(FluxConcatMapSupport<R> parent) {
            super(null);
            this.parent = parent;
        }

        public void onNext(R t) {
            ++this.produced;
            this.parent.innerNext(t);
        }

        @Override
        public void onError(Throwable t) {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.parent.innerComplete();
        }
    }

    static interface FluxConcatMapSupport<T> {
        public void innerNext(T var1);

        public void innerComplete();

        public void innerError(Throwable var1);
    }

    static final class ConcatMapDelayed<T, R>
    implements Subscriber<T>,
    FluxConcatMapSupport<R>,
    Subscription {
        final Subscriber<? super R> actual;
        final ConcatMapInner<R> inner;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final Supplier<? extends Queue<T>> queueSupplier;
        final int prefetch;
        final int limit;
        final boolean veryEnd;
        Subscription s;
        int consumed;
        volatile Queue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<ConcatMapDelayed, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(ConcatMapDelayed.class, Throwable.class, "error");
        volatile boolean active;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatMapDelayed> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatMapDelayed.class, "wip");
        int sourceMode;
        static final int SYNC = 1;
        static final int ASYNC = 2;

        public ConcatMapDelayed(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, Supplier<? extends Queue<T>> queueSupplier, int prefetch, boolean veryEnd) {
            this.actual = actual;
            this.mapper = mapper;
            this.queueSupplier = queueSupplier;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.veryEnd = veryEnd;
            this.inner = new ConcatMapInner(this);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                    } else {
                        try {
                            this.queue = this.queueSupplier.get();
                        }
                        catch (Throwable ex) {
                            Operators.error(this.actual, Operators.onOperatorError(s, ex));
                            return;
                        }
                    }
                } else {
                    try {
                        this.queue = this.queueSupplier.get();
                    }
                    catch (Throwable ex) {
                        Operators.error(this.actual, Operators.onOperatorError(s, ex));
                        return;
                    }
                }
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.drain();
            } else if (!this.queue.offer(t)) {
                this.s.cancel();
                this.onError(new IllegalStateException("Queue full?!"));
            } else {
                this.drain();
            }
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void innerNext(R value) {
            this.actual.onNext(value);
        }

        @Override
        public void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        public void innerError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                if (!this.veryEnd) {
                    this.s.cancel();
                    this.done = true;
                }
                this.active = false;
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        public void request(long n) {
            this.inner.request(n);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.s.cancel();
            }
        }

        void drain() {
            block22: {
                if (WIP.getAndIncrement(this) != 0) break block22;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        T v;
                        Throwable ex;
                        boolean d = this.done;
                        if (d && !this.veryEnd && (ex = this.error) != null) {
                            ex = Exceptions.terminate(ERROR, this);
                            if (ex != Exceptions.TERMINATED) {
                                this.actual.onError(ex);
                            }
                            return;
                        }
                        try {
                            v = this.queue.poll();
                        }
                        catch (Throwable e) {
                            this.actual.onError(Operators.onOperatorError(this.s, e));
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            Throwable ex2 = Exceptions.terminate(ERROR, this);
                            if (ex2 != null && ex2 != Exceptions.TERMINATED) {
                                this.actual.onError(ex2);
                            } else {
                                this.actual.onComplete();
                            }
                            return;
                        }
                        if (!empty) {
                            Publisher<? extends R> p;
                            try {
                                p = this.mapper.apply(v);
                            }
                            catch (Throwable e) {
                                this.actual.onError(Operators.onOperatorError(this.s, e, v));
                                return;
                            }
                            if (p == null) {
                                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null Publisher"), v));
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c = this.consumed + 1;
                                if (c == this.limit) {
                                    this.consumed = 0;
                                    this.s.request((long)c);
                                } else {
                                    this.consumed = c;
                                }
                            }
                            if (p instanceof Callable) {
                                Object vr;
                                Callable supplier = (Callable)p;
                                try {
                                    vr = supplier.call();
                                }
                                catch (Throwable e) {
                                    this.actual.onError(Operators.onOperatorError(this.s, e, v));
                                    return;
                                }
                                if (vr == null) continue;
                                if (this.inner.isUnbounded()) {
                                    this.actual.onNext(vr);
                                    continue;
                                }
                                this.active = true;
                                this.inner.set(new WeakScalarSubscription(vr, this.inner));
                            } else {
                                this.active = true;
                                p.subscribe(this.inner);
                            }
                        }
                    }
                    if (WIP.decrementAndGet(this) == 0) break;
                }
            }
        }
    }

    static final class WeakScalarSubscription<T>
    implements Subscription {
        final Subscriber<? super T> actual;
        final T value;
        boolean once;

        public WeakScalarSubscription(T value, Subscriber<? super T> actual) {
            this.value = value;
            this.actual = actual;
        }

        public void request(long n) {
            if (n > 0L && !this.once) {
                this.once = true;
                Subscriber<? super T> a = this.actual;
                a.onNext(this.value);
                a.onComplete();
            }
        }

        public void cancel() {
        }
    }

    static final class ConcatMapImmediate<T, R>
    implements Subscriber<T>,
    FluxConcatMapSupport<R>,
    Subscription {
        final Subscriber<? super R> actual;
        final ConcatMapInner<R> inner;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final Supplier<? extends Queue<T>> queueSupplier;
        final int prefetch;
        final int limit;
        Subscription s;
        int consumed;
        volatile Queue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<ConcatMapImmediate, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(ConcatMapImmediate.class, Throwable.class, "error");
        volatile boolean active;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatMapImmediate> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatMapImmediate.class, "wip");
        volatile int guard;
        static final AtomicIntegerFieldUpdater<ConcatMapImmediate> GUARD = AtomicIntegerFieldUpdater.newUpdater(ConcatMapImmediate.class, "guard");
        int sourceMode;
        static final int SYNC = 1;
        static final int ASYNC = 2;

        public ConcatMapImmediate(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, Supplier<? extends Queue<T>> queueSupplier, int prefetch) {
            this.actual = actual;
            this.mapper = mapper;
            this.queueSupplier = queueSupplier;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.inner = new ConcatMapInner(this);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                    } else {
                        try {
                            this.queue = this.queueSupplier.get();
                        }
                        catch (Throwable ex) {
                            Operators.error(this.actual, Operators.onOperatorError(s, ex));
                            return;
                        }
                    }
                } else {
                    try {
                        this.queue = this.queueSupplier.get();
                    }
                    catch (Throwable ex) {
                        s.cancel();
                        Operators.error(this.actual, ex);
                        return;
                    }
                }
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.drain();
            } else if (!this.queue.offer(t)) {
                this.s.cancel();
                this.onError(new IllegalStateException("Queue full?!"));
            } else {
                this.drain();
            }
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.inner.cancel();
                if (GUARD.getAndIncrement(this) == 0 && (t = Exceptions.terminate(ERROR, this)) != Exceptions.TERMINATED) {
                    this.actual.onError(t);
                }
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void innerNext(R value) {
            if (this.guard == 0 && GUARD.compareAndSet(this, 0, 1)) {
                this.actual.onNext(value);
                if (GUARD.compareAndSet(this, 1, 0)) {
                    return;
                }
                Throwable e = Exceptions.terminate(ERROR, this);
                if (e != Exceptions.TERMINATED) {
                    this.actual.onError(e);
                }
            }
        }

        @Override
        public void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        public void innerError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.s.cancel();
                if (GUARD.getAndIncrement(this) == 0 && (e = Exceptions.terminate(ERROR, this)) != Exceptions.TERMINATED) {
                    this.actual.onError(e);
                }
            } else {
                Operators.onErrorDropped(e);
            }
        }

        public void request(long n) {
            this.inner.request(n);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.s.cancel();
            }
        }

        void drain() {
            block19: {
                if (WIP.getAndIncrement(this) != 0) break block19;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        T v;
                        boolean d = this.done;
                        try {
                            v = this.queue.poll();
                        }
                        catch (Throwable e) {
                            this.actual.onError(Operators.onOperatorError(this.s, e));
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            this.actual.onComplete();
                            return;
                        }
                        if (!empty) {
                            Publisher<? extends R> p;
                            try {
                                p = this.mapper.apply(v);
                            }
                            catch (Throwable e) {
                                this.actual.onError(Operators.onOperatorError(this.s, e, v));
                                return;
                            }
                            if (p == null) {
                                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null Publisher"), v));
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c = this.consumed + 1;
                                if (c == this.limit) {
                                    this.consumed = 0;
                                    this.s.request((long)c);
                                } else {
                                    this.consumed = c;
                                }
                            }
                            if (p instanceof Callable) {
                                Object vr;
                                Callable callable = (Callable)p;
                                try {
                                    vr = callable.call();
                                }
                                catch (Throwable e) {
                                    this.actual.onError(Operators.onOperatorError(this.s, e, v));
                                    return;
                                }
                                if (vr == null) continue;
                                if (this.inner.isUnbounded()) {
                                    if (this.guard != 0 || !GUARD.compareAndSet(this, 0, 1)) continue;
                                    this.actual.onNext(vr);
                                    if (GUARD.compareAndSet(this, 1, 0)) continue;
                                    e = Exceptions.terminate(ERROR, this);
                                    if (e != Exceptions.TERMINATED) {
                                        this.actual.onError(e);
                                    }
                                    return;
                                }
                                this.active = true;
                                this.inner.set(new WeakScalarSubscription(vr, this.inner));
                            } else {
                                this.active = true;
                                p.subscribe(this.inner);
                            }
                        }
                    }
                    if (WIP.decrementAndGet(this) == 0) break;
                }
            }
        }
    }

    public static enum ErrorMode {
        IMMEDIATE,
        BOUNDARY,
        END;

    }
}

