/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxDistinctUntilChanged<T, K>
extends FluxSource<T, T> {
    final Function<? super T, K> keyExtractor;

    public FluxDistinctUntilChanged(Publisher<? extends T> source, Function<? super T, K> keyExtractor) {
        super(source);
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new DistinctUntilChangedConditionalSubscriber<T, K>((Fuseable.ConditionalSubscriber)s, this.keyExtractor));
        } else {
            this.source.subscribe(new DistinctUntilChangedSubscriber<T, K>(s, this.keyExtractor));
        }
    }

    static final class DistinctUntilChangedConditionalSubscriber<T, K>
    implements Fuseable.ConditionalSubscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Trackable {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final Function<? super T, K> keyExtractor;
        Subscription s;
        boolean done;
        K lastKey;

        public DistinctUntilChangedConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Function<? super T, K> keyExtractor) {
            this.actual = actual;
            this.keyExtractor = keyExtractor;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            K k;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                k = this.keyExtractor.apply(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            if (Objects.equals(this.lastKey, k)) {
                this.lastKey = k;
                return false;
            }
            this.lastKey = k;
            return this.actual.tryOnNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.keyExtractor;
        }

        @Override
        public Object connectedOutput() {
            return this.lastKey;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }

    static final class DistinctUntilChangedSubscriber<T, K>
    implements Fuseable.ConditionalSubscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Trackable {
        final Subscriber<? super T> actual;
        final Function<? super T, K> keyExtractor;
        Subscription s;
        boolean done;
        K lastKey;

        public DistinctUntilChangedSubscriber(Subscriber<? super T> actual, Function<? super T, K> keyExtractor) {
            this.actual = actual;
            this.keyExtractor = keyExtractor;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            K k;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                k = this.keyExtractor.apply(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            if (Objects.equals(this.lastKey, k)) {
                this.lastKey = k;
                return false;
            }
            this.lastKey = k;
            this.actual.onNext(t);
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.keyExtractor;
        }

        @Override
        public Object connectedOutput() {
            return this.lastKey;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

