/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.MultiReceiver;
import reactor.core.Producer;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxFirstEmitting<T>
extends Flux<T>
implements MultiReceiver {
    final Publisher<? extends T>[] array;
    final Iterable<? extends Publisher<? extends T>> iterable;

    @SafeVarargs
    public FluxFirstEmitting(Publisher<? extends T> ... array) {
        this.array = Objects.requireNonNull(array, "array");
        this.iterable = null;
    }

    public FluxFirstEmitting(Iterable<? extends Publisher<? extends T>> iterable) {
        this.array = null;
        this.iterable = Objects.requireNonNull(iterable);
    }

    @Override
    public Iterator<?> upstreams() {
        return this.iterable != null ? this.iterable.iterator() : Arrays.asList(this.array).iterator();
    }

    @Override
    public long upstreamCount() {
        return this.array != null ? (long)this.array.length : -1L;
    }

    public void subscribe(Subscriber<? super T> s) {
        int n;
        Publisher<? extends T>[] a;
        block15: {
            a = this.array;
            if (a == null) {
                Iterator<Publisher<T>> it;
                n = 0;
                a = new Publisher[8];
                try {
                    it = this.iterable.iterator();
                }
                catch (Throwable e) {
                    Operators.error(s, Operators.onOperatorError(e));
                    return;
                }
                if (it == null) {
                    Operators.error(s, new NullPointerException("The iterator returned is null"));
                    return;
                }
                while (true) {
                    Publisher<? extends T> p;
                    boolean b;
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable e) {
                        Operators.error(s, Operators.onOperatorError(e));
                        return;
                    }
                    if (!b) break block15;
                    try {
                        p = it.next();
                    }
                    catch (Throwable e) {
                        Operators.error(s, Operators.onOperatorError(e));
                        return;
                    }
                    if (p == null) {
                        Operators.error(s, new NullPointerException("The Publisher returned by the iterator is null"));
                        return;
                    }
                    if (n == a.length) {
                        Publisher[] c = new Publisher[n + (n >> 2)];
                        System.arraycopy(a, 0, c, 0, n);
                        a = c;
                    }
                    a[n++] = p;
                }
            }
            n = a.length;
        }
        if (n == 0) {
            Operators.complete(s);
            return;
        }
        if (n == 1) {
            Publisher<? extends T> p = a[0];
            if (p == null) {
                Operators.error(s, new NullPointerException("The single source Publisher is null"));
            } else {
                p.subscribe(s);
            }
            return;
        }
        RaceCoordinator<? super T> coordinator = new RaceCoordinator<T>(n);
        coordinator.subscribe(a, n, s);
    }

    public FluxFirstEmitting<T> ambAdditionalSource(Publisher<? extends T> source) {
        if (this.array != null) {
            int n = this.array.length;
            Publisher[] newArray = new Publisher[n + 1];
            System.arraycopy(this.array, 0, newArray, 0, n);
            newArray[n] = source;
            return new FluxFirstEmitting<T>(newArray);
        }
        return null;
    }

    static final class FirstEmittingSubscriber<T>
    extends Operators.DeferredSubscription
    implements Subscriber<T>,
    Producer {
        final RaceCoordinator<T> parent;
        final Subscriber<? super T> actual;
        final int index;
        boolean won;

        public FirstEmittingSubscriber(Subscriber<? super T> actual, RaceCoordinator<T> parent, int index) {
            this.actual = actual;
            this.parent = parent;
            this.index = index;
        }

        public void onSubscribe(Subscription s) {
            this.set(s);
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        public void onNext(T t) {
            if (this.won) {
                this.actual.onNext(t);
            } else if (this.parent.tryWin(this.index)) {
                this.won = true;
                this.actual.onNext(t);
            }
        }

        public void onError(Throwable t) {
            if (this.won) {
                this.actual.onError(t);
            } else if (this.parent.tryWin(this.index)) {
                this.won = true;
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            if (this.won) {
                this.actual.onComplete();
            } else if (this.parent.tryWin(this.index)) {
                this.won = true;
                this.actual.onComplete();
            }
        }
    }

    static final class RaceCoordinator<T>
    implements Subscription,
    MultiReceiver,
    Trackable {
        final FirstEmittingSubscriber<T>[] subscribers;
        volatile boolean cancelled;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RaceCoordinator> WIP = AtomicIntegerFieldUpdater.newUpdater(RaceCoordinator.class, "wip");

        public RaceCoordinator(int n) {
            this.subscribers = new FirstEmittingSubscriber[n];
            this.wip = Integer.MIN_VALUE;
        }

        void subscribe(Publisher<? extends T>[] sources, int n, Subscriber<? super T> actual) {
            int i;
            FirstEmittingSubscriber<T>[] a = this.subscribers;
            for (i = 0; i < n; ++i) {
                a[i] = new FirstEmittingSubscriber<T>(actual, this, i);
            }
            actual.onSubscribe((Subscription)this);
            for (i = 0; i < n; ++i) {
                if (this.cancelled || this.wip != Integer.MIN_VALUE) {
                    return;
                }
                Publisher<? extends T> p = sources[i];
                if (p == null) {
                    if (WIP.compareAndSet(this, Integer.MIN_VALUE, -1)) {
                        actual.onError((Throwable)new NullPointerException("The " + i + " th Publisher source is null"));
                    }
                    return;
                }
                p.subscribe(a[i]);
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                int w = this.wip;
                if (w >= 0) {
                    this.subscribers[w].request(n);
                } else {
                    for (FirstEmittingSubscriber<T> s : this.subscribers) {
                        s.request(n);
                    }
                }
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            int w = this.wip;
            if (w >= 0) {
                this.subscribers[w].cancel();
            } else {
                for (FirstEmittingSubscriber<T> s : this.subscribers) {
                    s.cancel();
                }
            }
        }

        boolean tryWin(int index) {
            if (this.wip == Integer.MIN_VALUE && WIP.compareAndSet(this, Integer.MIN_VALUE, index)) {
                FirstEmittingSubscriber<T>[] a = this.subscribers;
                int n = a.length;
                for (int i = 0; i < n; ++i) {
                    if (i == index) continue;
                    a[i].cancel();
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public Iterator<?> upstreams() {
            return Arrays.asList(this.subscribers).iterator();
        }

        @Override
        public long upstreamCount() {
            return this.subscribers.length;
        }
    }
}

