/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SynchronousSink;

final class FluxHandleFuseable<T, R>
extends FluxSource<T, R>
implements Fuseable {
    final BiConsumer<? super T, SynchronousSink<R>> handler;

    public FluxHandleFuseable(Publisher<? extends T> source, BiConsumer<? super T, SynchronousSink<R>> handler) {
        super(source);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new HandleFuseableConditionalSubscriber<T, R>(cs, this.handler));
            return;
        }
        this.source.subscribe(new HandleFuseableSubscriber<T, R>(s, this.handler));
    }

    static final class HandleFuseableConditionalSubscriber<T, R>
    implements Fuseable.ConditionalSubscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Fuseable.SynchronousSubscription<R>,
    Trackable,
    SynchronousSink<R> {
        final Fuseable.ConditionalSubscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        Throwable error;
        R data;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        public HandleFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int m = this.sourceMode;
            if (m == 0) {
                try {
                    this.handler.accept(t, this);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                R v = this.data;
                this.data = null;
                if (v != null) {
                    this.actual.onNext(v);
                }
                if (this.done) {
                    this.s.cancel();
                    if (this.error != null) {
                        this.actual.onError(this.error);
                        return;
                    }
                    this.actual.onComplete();
                } else if (v == null) {
                    this.s.request(1L);
                }
            } else if (m == 2) {
                this.actual.onNext(null);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            int m = this.sourceMode;
            if (m == 0) {
                try {
                    this.handler.accept(t, this);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return false;
                }
                R v = this.data;
                this.data = null;
                boolean emit = false;
                if (v != null) {
                    emit = this.actual.tryOnNext(v);
                }
                if (this.done) {
                    this.s.cancel();
                    if (this.error != null) {
                        this.actual.onError(this.error);
                    } else {
                        this.actual.onComplete();
                    }
                    return emit;
                }
                if (v == null) {
                    return false;
                }
            } else if (m == 2) {
                this.actual.onNext(null);
            }
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Operators.onOperatorError(Objects.requireNonNull(e, "error"));
            this.done = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.handler;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public R poll() {
            Object v;
            if (this.done) {
                if (this.error != null) {
                    throw Exceptions.propagate(this.error);
                }
                return null;
            }
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) != null) {
                        this.handler.accept(v2, this);
                        R u = this.data;
                        this.data = null;
                        if (this.done) {
                            this.s.cancel();
                            if (this.error != null) {
                                this.actual.onError(this.error);
                            } else {
                                this.actual.onComplete();
                            }
                            return u;
                        }
                        if (u != null) {
                            return u;
                        }
                        ++dropped;
                        continue;
                    }
                    if (dropped == 0L) break;
                    this.request(dropped);
                    dropped = 0L;
                }
                return null;
            }
            while ((v = this.s.poll()) != null) {
                this.handler.accept(v, this);
                R u = this.data;
                this.data = null;
                if (this.done) {
                    if (this.error != null) {
                        throw Exceptions.propagate(this.error);
                    }
                    return u;
                }
                if (u == null) continue;
                return u;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = (requestedMode & 4) != 0 ? 0 : this.s.requestFusion(requestedMode);
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }

    static final class HandleFuseableSubscriber<T, R>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Fuseable.ConditionalSubscriber<T>,
    Fuseable.SynchronousSubscription<R>,
    Trackable,
    SynchronousSink<R> {
        final Subscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        Throwable error;
        R data;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        public HandleFuseableSubscriber(Subscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            int m = this.sourceMode;
            if (m == 0) {
                try {
                    this.handler.accept(t, this);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return false;
                }
                R v = this.data;
                this.data = null;
                if (v != null) {
                    this.actual.onNext(v);
                }
                if (this.done) {
                    this.s.cancel();
                    if (this.error != null) {
                        this.actual.onError(this.error);
                    } else {
                        this.actual.onComplete();
                    }
                }
                if (v == null) {
                    return false;
                }
            } else if (m == 2) {
                this.actual.onNext(null);
            }
            return true;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int m = this.sourceMode;
            if (m == 0) {
                try {
                    this.handler.accept(t, this);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                R v = this.data;
                this.data = null;
                if (v != null) {
                    this.actual.onNext(v);
                }
                if (this.done) {
                    this.s.cancel();
                    if (this.error != null) {
                        this.actual.onError(this.error);
                        return;
                    }
                    this.actual.onComplete();
                } else if (v == null) {
                    this.s.request(1L);
                }
            } else if (m == 2) {
                this.actual.onNext(null);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.handler;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public R poll() {
            Object v;
            if (this.done) {
                if (this.error != null) {
                    throw Exceptions.propagate(this.error);
                }
                return null;
            }
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) != null) {
                        this.handler.accept(v2, this);
                        R u = this.data;
                        this.data = null;
                        if (this.done) {
                            this.s.cancel();
                            if (this.error != null) {
                                this.actual.onError(this.error);
                            }
                            return u;
                        }
                        if (u != null) {
                            return u;
                        }
                        ++dropped;
                        continue;
                    }
                    if (dropped == 0L) break;
                    this.request(dropped);
                    dropped = 0L;
                }
                return null;
            }
            while ((v = this.s.poll()) != null) {
                this.handler.accept(v, this);
                R u = this.data;
                this.data = null;
                if (this.done) {
                    if (this.error != null) {
                        throw Exceptions.propagate(this.error);
                    }
                    return u;
                }
                if (u == null) continue;
                return u;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = (requestedMode & 4) != 0 ? 0 : this.s.requestFusion(requestedMode);
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Operators.onOperatorError(Objects.requireNonNull(e, "error"));
            this.done = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }
    }
}

