/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.TimedScheduler;

final class FluxInterval
extends Flux<Long> {
    final TimedScheduler timedScheduler;
    final long initialDelay;
    final long period;
    final TimeUnit unit;

    public FluxInterval(long initialDelay, long period, TimeUnit unit, TimedScheduler timedScheduler) {
        if (period < 0L) {
            throw new IllegalArgumentException("period >= 0 required but it was " + period);
        }
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.timedScheduler = Objects.requireNonNull(timedScheduler, "timedScheduler");
    }

    public void subscribe(Subscriber<? super Long> s) {
        TimedScheduler.TimedWorker w = this.timedScheduler.createWorker();
        IntervalRunnable r = new IntervalRunnable(s, w);
        s.onSubscribe((Subscription)r);
        w.schedulePeriodically(r, this.initialDelay, this.period, this.unit);
    }

    static final class IntervalRunnable
    implements Runnable,
    Subscription {
        final Subscriber<? super Long> s;
        final TimedScheduler.TimedWorker worker;
        volatile long requested;
        static final AtomicLongFieldUpdater<IntervalRunnable> REQUESTED = AtomicLongFieldUpdater.newUpdater(IntervalRunnable.class, "requested");
        long count;
        volatile boolean cancelled;

        public IntervalRunnable(Subscriber<? super Long> s, TimedScheduler.TimedWorker worker) {
            this.s = s;
            this.worker = worker;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                if (this.requested != 0L) {
                    this.s.onNext((Object)this.count++);
                    if (this.requested != Long.MAX_VALUE) {
                        REQUESTED.decrementAndGet(this);
                    }
                } else {
                    this.cancel();
                    this.s.onError((Throwable)new IllegalStateException("Could not emit value " + this.count + " due to lack of requests"));
                }
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.worker.shutdown();
            }
        }
    }
}

