/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxRefCount<T>
extends Flux<T>
implements Receiver,
Loopback,
Fuseable {
    final ConnectableFlux<? extends T> source;
    final int n;
    volatile State<T> connection;
    static final AtomicReferenceFieldUpdater<FluxRefCount, State> CONNECTION = AtomicReferenceFieldUpdater.newUpdater(FluxRefCount.class, State.class, "connection");

    public FluxRefCount(ConnectableFlux<? extends T> source, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > 0 required but it was " + n);
        }
        this.source = Objects.requireNonNull(source, "source");
        this.n = n;
    }

    public void subscribe(Subscriber<? super T> s) {
        State<? super T> state;
        while ((state = this.connection) == null || state.isDisconnected()) {
            State u = new State(this.n, this);
            if (!CONNECTION.compareAndSet(this, state, u)) continue;
            state = u;
            break;
        }
        state.subscribe(s);
    }

    @Override
    public Object connectedOutput() {
        return this.connection;
    }

    @Override
    public Object upstream() {
        return this.source;
    }

    static final class State<T>
    implements Consumer<Cancellation>,
    MultiProducer,
    Receiver {
        final int n;
        final FluxRefCount<? extends T> parent;
        volatile int subscribers;
        static final AtomicIntegerFieldUpdater<State> SUBSCRIBERS = AtomicIntegerFieldUpdater.newUpdater(State.class, "subscribers");
        volatile Cancellation disconnect;
        static final AtomicReferenceFieldUpdater<State, Cancellation> DISCONNECT = AtomicReferenceFieldUpdater.newUpdater(State.class, Cancellation.class, "disconnect");
        static final Cancellation DISCONNECTED = () -> {};

        public State(int n, FluxRefCount<? extends T> parent) {
            this.n = n;
            this.parent = parent;
        }

        void subscribe(Subscriber<? super T> s) {
            InnerSubscriber<? super T> inner = new InnerSubscriber<T>(s, this);
            this.parent.source.subscribe(inner);
            if (SUBSCRIBERS.incrementAndGet(this) == this.n) {
                this.parent.source.connect(this);
            }
        }

        @Override
        public void accept(Cancellation r) {
            if (!DISCONNECT.compareAndSet(this, null, r)) {
                r.dispose();
            }
        }

        void doDisconnect() {
            Cancellation a = this.disconnect;
            if (a != DISCONNECTED && (a = DISCONNECT.getAndSet(this, DISCONNECTED)) != null && a != DISCONNECTED) {
                a.dispose();
            }
        }

        boolean isDisconnected() {
            return this.disconnect == DISCONNECTED;
        }

        void innerCancelled() {
            if (SUBSCRIBERS.decrementAndGet(this) == 0) {
                this.doDisconnect();
            }
        }

        void upstreamFinished() {
            Cancellation a = this.disconnect;
            if (a != DISCONNECTED) {
                DISCONNECT.getAndSet(this, DISCONNECTED);
            }
        }

        @Override
        public Iterator<?> downstreams() {
            return null;
        }

        @Override
        public long downstreamCount() {
            return this.subscribers;
        }

        @Override
        public Object upstream() {
            return this.parent;
        }

        static final class InnerSubscriber<T>
        implements Subscriber<T>,
        Fuseable.QueueSubscription<T>,
        Receiver,
        Producer,
        Loopback {
            final Subscriber<? super T> actual;
            final State<T> parent;
            Subscription s;
            Fuseable.QueueSubscription<T> qs;

            public InnerSubscriber(Subscriber<? super T> actual, State<T> parent) {
                this.actual = actual;
                this.parent = parent;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.validate(this.s, s)) {
                    this.s = s;
                    this.actual.onSubscribe((Subscription)this);
                }
            }

            public void onNext(T t) {
                this.actual.onNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
                this.parent.upstreamFinished();
            }

            public void onComplete() {
                this.actual.onComplete();
                this.parent.upstreamFinished();
            }

            public void request(long n) {
                this.s.request(n);
            }

            public void cancel() {
                this.s.cancel();
                this.parent.innerCancelled();
            }

            @Override
            public Object downstream() {
                return this.actual;
            }

            @Override
            public Object upstream() {
                return this.s;
            }

            @Override
            public Object connectedInput() {
                return null;
            }

            @Override
            public Object connectedOutput() {
                return this.s;
            }

            @Override
            public int requestFusion(int requestedMode) {
                if (this.s instanceof Fuseable.QueueSubscription) {
                    this.qs = (Fuseable.QueueSubscription)this.s;
                    return this.qs.requestFusion(requestedMode);
                }
                return 0;
            }

            @Override
            public T poll() {
                return (T)this.qs.poll();
            }

            @Override
            public int size() {
                return this.qs.size();
            }

            @Override
            public boolean isEmpty() {
                return this.qs.isEmpty();
            }

            @Override
            public void clear() {
                this.qs.clear();
            }
        }
    }
}

