/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ReplayProcessor;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.concurrent.QueueSupplier;

final class FluxReplay<T>
extends ConnectableFlux<T>
implements Producer,
Fuseable {
    final Publisher<T> source;
    final int history;
    final long ttl;
    final TimedScheduler scheduler;
    volatile State<T> connection;
    static final AtomicReferenceFieldUpdater<FluxReplay, State> CONNECTION = AtomicReferenceFieldUpdater.newUpdater(FluxReplay.class, State.class, "connection");

    FluxReplay(Publisher<T> source, int history, long ttl, TimedScheduler scheduler) {
        this.source = Objects.requireNonNull(source, "source");
        this.history = history;
        if (scheduler != null && ttl < 0L) {
            throw new IllegalArgumentException("TTL cannot be negative : " + ttl);
        }
        this.ttl = ttl;
        this.scheduler = scheduler;
    }

    @Override
    public Object downstream() {
        return this.connection;
    }

    State<T> newState() {
        if (this.scheduler != null) {
            return new State(new ReplayProcessor.SizeAndTimeBoundReplayBuffer(this.history, this.ttl, this.scheduler), this);
        }
        if (this.history != Integer.MAX_VALUE) {
            return new State(new ReplayProcessor.SizeBoundReplayBuffer(this.history), this);
        }
        return new State(new ReplayProcessor.UnboundedReplayBuffer(QueueSupplier.SMALL_BUFFER_SIZE), this);
    }

    @Override
    public void connect(Consumer<? super Cancellation> cancelSupport) {
        State<T> s;
        while ((s = this.connection) == null || s.isTerminated()) {
            State<T> u = this.newState();
            if (!CONNECTION.compareAndSet(this, s, u)) continue;
            s = u;
            break;
        }
        boolean doConnect = s.tryConnect();
        cancelSupport.accept(s);
        if (doConnect) {
            this.source.subscribe(s);
        }
    }

    public void subscribe(Subscriber<? super T> s) {
        InnerSubscription<T> inner = new InnerSubscription<T>(s);
        s.onSubscribe(inner);
        while (!inner.isCancelled()) {
            State<? super T> c = this.connection;
            if (c == null || c.isTerminated()) {
                State<T> u = this.newState();
                if (!CONNECTION.compareAndSet(this, c, u)) continue;
                c = u;
            }
            if (!c.trySubscribe(inner)) continue;
            break;
        }
    }

    @Override
    public Object upstream() {
        return this.source;
    }

    static final class InnerSubscription<T>
    implements ReplayProcessor.ReplaySubscription<T>,
    Receiver {
        final Subscriber<? super T> actual;
        State<T> parent;
        int index;
        int tailIndex;
        Object node;
        int fusionMode;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<InnerSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(InnerSubscription.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<InnerSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(InnerSubscription.class, "requested");
        volatile int cancelled;
        static final AtomicIntegerFieldUpdater<InnerSubscription> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(InnerSubscription.class, "cancelled");

        public InnerSubscription(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                State<T> p;
                if (this.fusionMode() == 0) {
                    Operators.getAndAddCap(REQUESTED, this, n);
                }
                if ((p = this.parent) != null) {
                    p.buffer.replay(this);
                }
            }
        }

        public void cancel() {
            if (CANCELLED.compareAndSet(this, 0, 1)) {
                State<T> p = this.parent;
                if (p != null) {
                    p.remove(this);
                }
                if (this.enter()) {
                    this.node = null;
                }
            }
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled == 1;
        }

        @Override
        public Subscriber<? super T> downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.parent;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.fusionMode = 2;
                return 2;
            }
            return 0;
        }

        @Override
        public T poll() {
            State<T> p = this.parent;
            if (p != null) {
                return p.buffer.poll(this);
            }
            return null;
        }

        @Override
        public void clear() {
            State<T> p = this.parent;
            if (p != null) {
                p.buffer.clear(this);
            }
        }

        @Override
        public boolean isEmpty() {
            State<T> p = this.parent;
            if (p != null) {
                p.buffer.isEmpty(this);
            }
            return true;
        }

        @Override
        public int size() {
            State<T> p = this.parent;
            if (p != null) {
                p.buffer.size(this);
            }
            return 0;
        }

        @Override
        public void node(Object node) {
            this.node = node;
        }

        @Override
        public int fusionMode() {
            return this.fusionMode;
        }

        @Override
        public Object node() {
            return this.node;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void index(int index) {
            this.index = index;
        }

        @Override
        public int tailIndex() {
            return this.tailIndex;
        }

        @Override
        public void tailIndex(int tailIndex) {
            this.tailIndex = tailIndex;
        }

        @Override
        public boolean enter() {
            return WIP.getAndIncrement(this) == 0;
        }

        @Override
        public int leave(int missed) {
            return WIP.addAndGet(this, -missed);
        }

        @Override
        public void produced(long n) {
            REQUESTED.addAndGet(this, -n);
        }
    }

    static final class State<T>
    implements Subscriber<T>,
    Receiver,
    MultiProducer,
    Trackable,
    Cancellation {
        final FluxReplay<T> parent;
        final ReplayProcessor.ReplayBuffer<T> buffer;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<State, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(State.class, Subscription.class, "s");
        volatile InnerSubscription<T>[] subscribers;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<State> WIP = AtomicIntegerFieldUpdater.newUpdater(State.class, "wip");
        volatile int connected;
        static final AtomicIntegerFieldUpdater<State> CONNECTED = AtomicIntegerFieldUpdater.newUpdater(State.class, "connected");
        static final InnerSubscription[] EMPTY = new InnerSubscription[0];
        static final InnerSubscription[] TERMINATED = new InnerSubscription[0];
        volatile boolean cancelled;

        public State(ReplayProcessor.ReplayBuffer<T> buffer, FluxReplay<T> parent) {
            this.buffer = buffer;
            this.parent = parent;
            this.subscribers = EMPTY;
        }

        public void onSubscribe(Subscription s) {
            if (this.buffer.isDone()) {
                s.cancel();
            } else if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            ReplayProcessor.ReplayBuffer<T> b = this.buffer;
            if (b.isDone()) {
                Operators.onNextDropped(t);
            } else {
                b.add(t);
                for (InnerSubscription<T> rs : this.subscribers) {
                    b.replay(rs);
                }
            }
        }

        public void onError(Throwable t) {
            ReplayProcessor.ReplayBuffer<T> b = this.buffer;
            if (b.isDone()) {
                Operators.onErrorDropped(t);
            } else {
                InnerSubscription<T>[] a;
                b.onError(t);
                for (InnerSubscription<T> rs : a = this.subscribers) {
                    b.replay(rs);
                }
            }
        }

        public void onComplete() {
            ReplayProcessor.ReplayBuffer<T> b = this.buffer;
            if (!b.isDone()) {
                InnerSubscription<T>[] a;
                b.onComplete();
                for (InnerSubscription<T> rs : a = this.subscribers) {
                    b.replay(rs);
                }
            }
        }

        @Override
        public void dispose() {
            if (this.cancelled) {
                return;
            }
            if (Operators.terminate(S, this)) {
                this.cancelled = true;
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
                this.disconnectAction();
            }
        }

        void disconnectAction() {
            CancellationException ex = new CancellationException("Disconnected");
            this.buffer.onError(ex);
            for (InnerSubscription<T> inner : this.terminate()) {
                inner.actual.onError((Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(InnerSubscription<T> inner) {
            if (this.subscribers == TERMINATED) {
                return false;
            }
            State state = this;
            synchronized (state) {
                InnerSubscription<T>[] a = this.subscribers;
                if (a == TERMINATED) {
                    return false;
                }
                int n = a.length;
                InnerSubscription[] b = new InnerSubscription[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner;
                this.subscribers = b;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(InnerSubscription<T> inner) {
            InnerSubscription<T>[] a = this.subscribers;
            if (a == TERMINATED || a == EMPTY) {
                return;
            }
            State state = this;
            synchronized (state) {
                InnerSubscription[] b;
                a = this.subscribers;
                if (a == TERMINATED || a == EMPTY) {
                    return;
                }
                int j = -1;
                int n = a.length;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                } else {
                    b = new InnerSubscription[n - 1];
                    System.arraycopy(a, 0, b, 0, j);
                    System.arraycopy(a, j + 1, b, j, n - j - 1);
                }
                this.subscribers = b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InnerSubscription<T>[] terminate() {
            InnerSubscription<T>[] a = this.subscribers;
            if (a == TERMINATED) {
                return a;
            }
            State state = this;
            synchronized (state) {
                a = this.subscribers;
                if (a != TERMINATED) {
                    this.subscribers = TERMINATED;
                }
                return a;
            }
        }

        @Override
        public boolean isTerminated() {
            return this.subscribers == TERMINATED;
        }

        boolean tryConnect() {
            return this.connected == 0 && CONNECTED.compareAndSet(this, 0, 1);
        }

        boolean trySubscribe(InnerSubscription<T> inner) {
            if (this.add(inner)) {
                if (inner.isCancelled()) {
                    this.remove(inner);
                } else {
                    inner.parent = this;
                    this.buffer.replay(inner);
                }
                return true;
            }
            return false;
        }

        @Override
        public long getCapacity() {
            return this.buffer instanceof ReplayProcessor.UnboundedReplayBuffer ? Long.MAX_VALUE : (long)this.buffer.capacity();
        }

        @Override
        public long getPending() {
            return this.buffer.size();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isStarted() {
            return !this.cancelled && !this.buffer.isDone() && this.s != null;
        }

        @Override
        public Throwable getError() {
            return this.buffer.getError();
        }

        @Override
        public Iterator<?> downstreams() {
            return Arrays.asList(this.subscribers).iterator();
        }

        @Override
        public long downstreamCount() {
            return this.subscribers.length;
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

