/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxSampleFirst<T, U>
extends FluxSource<T, T> {
    final Function<? super T, ? extends Publisher<U>> throttler;

    public FluxSampleFirst(Publisher<? extends T> source, Function<? super T, ? extends Publisher<U>> throttler) {
        super(source);
        this.throttler = Objects.requireNonNull(throttler, "throttler");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        ThrottleFirstMain main = new ThrottleFirstMain(s, this.throttler);
        s.onSubscribe(main);
        this.source.subscribe(main);
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    static final class ThrottleFirstOther<U>
    extends Operators.DeferredSubscription
    implements Subscriber<U> {
        final ThrottleFirstMain<?, U> main;

        public ThrottleFirstOther(ThrottleFirstMain<?, U> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            this.cancel();
            this.main.otherNext();
        }

        public void onError(Throwable t) {
            this.main.otherError(t);
        }

        public void onComplete() {
            this.main.otherNext();
        }
    }

    static final class ThrottleFirstMain<T, U>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final Function<? super T, ? extends Publisher<U>> throttler;
        volatile boolean gate;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ThrottleFirstMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ThrottleFirstMain.class, Subscription.class, "s");
        volatile Subscription other;
        static final AtomicReferenceFieldUpdater<ThrottleFirstMain, Subscription> OTHER = AtomicReferenceFieldUpdater.newUpdater(ThrottleFirstMain.class, Subscription.class, "other");
        volatile long requested;
        static final AtomicLongFieldUpdater<ThrottleFirstMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(ThrottleFirstMain.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ThrottleFirstMain> WIP = AtomicIntegerFieldUpdater.newUpdater(ThrottleFirstMain.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<ThrottleFirstMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(ThrottleFirstMain.class, Throwable.class, "error");

        public ThrottleFirstMain(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<U>> throttler) {
            this.actual = actual;
            this.throttler = throttler;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
            Operators.terminate(OTHER, this);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (!this.gate) {
                Publisher<U> p;
                this.gate = true;
                if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                    this.actual.onNext(t);
                    if (WIP.decrementAndGet(this) != 0) {
                        this.handleTermination();
                        return;
                    }
                } else {
                    return;
                }
                try {
                    p = this.throttler.apply(t);
                }
                catch (Throwable e) {
                    Operators.terminate(S, this);
                    this.error(Operators.onOperatorError(null, e, t));
                    return;
                }
                if (p == null) {
                    Operators.terminate(S, this);
                    this.error(new NullPointerException("The throttler returned a null publisher"));
                    return;
                }
                ThrottleFirstOther other = new ThrottleFirstOther(this);
                if (Operators.replace(OTHER, this, other)) {
                    p.subscribe(other);
                }
            }
        }

        void handleTermination() {
            Throwable e = Exceptions.terminate(ERROR, this);
            if (e != null && e != Exceptions.TERMINATED) {
                this.actual.onError(e);
            } else {
                this.actual.onComplete();
            }
        }

        void error(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                if (WIP.getAndIncrement(this) == 0) {
                    this.handleTermination();
                }
            } else {
                Operators.onErrorDropped(e);
            }
        }

        public void onError(Throwable t) {
            Operators.terminate(OTHER, this);
            this.error(t);
        }

        public void onComplete() {
            Operators.terminate(OTHER, this);
            if (WIP.getAndIncrement(this) == 0) {
                this.handleTermination();
            }
        }

        void otherNext() {
            this.gate = false;
        }

        void otherError(Throwable e) {
            Operators.terminate(S, this);
            this.error(e);
        }
    }
}

