/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayDeque;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxSkipLast<T>
extends FluxSource<T, T> {
    final int n;

    public FluxSkipLast(Publisher<? extends T> source, int n) {
        super(source);
        if (n < 0) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        this.n = n;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.n == 0) {
            this.source.subscribe(s);
        } else {
            this.source.subscribe(new SkipLastSubscriber<T>(s, this.n));
        }
    }

    static final class SkipLastSubscriber<T>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Subscription,
    Trackable {
        final Subscriber<? super T> actual;
        final int n;
        final ArrayDeque<T> buffer;
        Subscription s;

        public SkipLastSubscriber(Subscriber<? super T> actual, int n) {
            this.actual = actual;
            this.n = n;
            this.buffer = new ArrayDeque();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.n);
            }
        }

        public void onNext(T t) {
            ArrayDeque<T> bs = this.buffer;
            if (bs.size() == this.n) {
                T v = bs.poll();
                this.actual.onNext(v);
            }
            bs.offer(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public long getPending() {
            return this.buffer.size();
        }

        @Override
        public long getCapacity() {
            return this.n;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

