/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.FluxSubscribeOnValue;
import reactor.core.publisher.MonoSubscribeOnCallable;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxSubscribeOn<T>
extends FluxSource<T, T>
implements Loopback {
    final Scheduler scheduler;

    public FluxSubscribeOn(Publisher<? extends T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Scheduler.Worker worker;
        if (this.source instanceof Fuseable.ScalarCallable) {
            if (!FluxSubscribeOnValue.scalarScheduleOn(this.source, s, this.scheduler)) {
                MonoSubscribeOnCallable.subscribe((Callable)this.source, s, this.scheduler);
            }
            return;
        }
        try {
            worker = this.scheduler.createWorker();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (worker == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The scheduler returned a null Function")));
            return;
        }
        SubscribeOnSubscriber<? super T> parent = new SubscribeOnSubscriber<T>(s, worker);
        s.onSubscribe(parent);
        worker.schedule(new SourceSubscribeTask<T>(parent, this.source));
    }

    @Override
    public Object connectedInput() {
        return this.scheduler;
    }

    @Override
    public Object connectedOutput() {
        return null;
    }

    static final class SourceSubscribeTask<T>
    implements Runnable {
        final SubscribeOnSubscriber<T> actual;
        final Publisher<? extends T> source;

        public SourceSubscribeTask(SubscribeOnSubscriber<T> s, Publisher<? extends T> source) {
            this.actual = s;
            this.source = source;
        }

        @Override
        public void run() {
            SubscribeOnSubscriber.THREAD.lazySet(this.actual, Thread.currentThread());
            this.source.subscribe(this.actual);
        }
    }

    static final class SubscribeOnSubscriber<T>
    implements Subscription,
    Subscriber<T>,
    Producer,
    Loopback {
        final Subscriber<? super T> actual;
        final Scheduler.Worker worker;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SubscribeOnSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SubscribeOnSubscriber.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<SubscribeOnSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(SubscribeOnSubscriber.class, "requested");
        volatile Thread thread;
        static final AtomicReferenceFieldUpdater<SubscribeOnSubscriber, Thread> THREAD = AtomicReferenceFieldUpdater.newUpdater(SubscribeOnSubscriber.class, Thread.class, "thread");

        public SubscribeOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker) {
            this.actual = actual;
            this.worker = worker;
        }

        public void onSubscribe(Subscription s) {
            long r;
            if (Operators.setOnce(S, this, s) && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                this.requestUpstream(r, s);
            }
        }

        void requestUpstream(long n, Subscription s) {
            if (Thread.currentThread() == THREAD.get(this)) {
                s.request(n);
            } else {
                this.worker.schedule(() -> s.request(n));
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            try {
                this.actual.onError(t);
            }
            finally {
                this.worker.shutdown();
            }
        }

        public void onComplete() {
            try {
                this.actual.onComplete();
            }
            finally {
                this.worker.shutdown();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Subscription s = S.get(this);
                if (s != null) {
                    this.requestUpstream(n, s);
                } else {
                    long r;
                    Operators.addAndGet(REQUESTED, this, n);
                    s = S.get(this);
                    if (s != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                        this.requestUpstream(r, s);
                    }
                }
            }
        }

        public void cancel() {
            Subscription a = this.s;
            if (a != Operators.cancelledSubscription() && (a = S.getAndSet(this, Operators.cancelledSubscription())) != null && a != Operators.cancelledSubscription()) {
                a.cancel();
            }
            this.worker.shutdown();
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedOutput() {
            return this.worker;
        }

        @Override
        public Object connectedInput() {
            return null;
        }
    }
}

