/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxTakeLast<T>
extends FluxSource<T, T> {
    final int n;

    public FluxTakeLast(Publisher<? extends T> source, int n) {
        super(source);
        if (n < 0) {
            throw new IllegalArgumentException("n >= required but it was " + n);
        }
        this.n = n;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.n == 0) {
            this.source.subscribe(new TakeLastZeroSubscriber<T>(s));
        } else {
            this.source.subscribe(new TakeLastManySubscriber<T>(s, this.n));
        }
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    static final class TakeLastManySubscriber<T>
    implements Subscriber<T>,
    BooleanSupplier,
    Producer,
    Trackable,
    Subscription,
    Receiver {
        final Subscriber<? super T> actual;
        final int n;
        volatile boolean cancelled;
        Subscription s;
        final ArrayDeque<T> buffer;
        volatile long requested;
        static final AtomicLongFieldUpdater<TakeLastManySubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(TakeLastManySubscriber.class, "requested");

        public TakeLastManySubscriber(Subscriber<? super T> actual, int n) {
            this.actual = actual;
            this.n = n;
            this.buffer = new ArrayDeque();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                DrainUtils.postCompleteRequest(n, this.actual, this.buffer, REQUESTED, this, this);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            ArrayDeque<T> bs = this.buffer;
            if (bs.size() == this.n) {
                bs.poll();
            }
            bs.offer(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            DrainUtils.postComplete(this.actual, this.buffer, REQUESTED, this, this);
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public long getPending() {
            return this.buffer.size();
        }

        @Override
        public long getCapacity() {
            return this.n;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }
    }

    static final class TakeLastZeroSubscriber<T>
    implements Subscriber<T>,
    Producer,
    Subscription,
    Receiver {
        final Subscriber<? super T> actual;
        Subscription s;

        public TakeLastZeroSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

