/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxBatch;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.TimedScheduler;

final class FluxWindowTimeOrSize<T>
extends FluxBatch<T, Flux<T>> {
    public FluxWindowTimeOrSize(Publisher<T> source, int backlog, long timespan, TimedScheduler timer) {
        super(source, backlog, timespan, timer);
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> subscriber) {
        this.source.subscribe(new WindowAction(this.prepareSub(subscriber), this.batchSize, this.timespan, this.timer));
    }

    static final class WindowAction<T>
    extends FluxBatch.BatchAction<T, Flux<T>>
    implements Loopback {
        private final TimedScheduler timer;
        private Window<T> currentWindow;

        public WindowAction(Subscriber<? super Flux<T>> actual, int backlog, long timespan, TimedScheduler timer) {
            super(actual, backlog, true, timespan, timer.createWorker());
            this.timer = timer;
        }

        protected Flux<T> createWindowStream() {
            Window _currentWindow = new Window(this.timer);
            _currentWindow.onSubscribe(new Subscription(){

                public void cancel() {
                    currentWindow = null;
                }

                public void request(long n) {
                }
            });
            this.currentWindow = _currentWindow;
            return _currentWindow;
        }

        @Override
        protected void checkedError(Throwable ev) {
            if (this.currentWindow != null) {
                this.currentWindow.onError(ev);
            }
            super.checkedError(ev);
        }

        @Override
        protected void checkedComplete() {
            try {
                if (this.currentWindow != null) {
                    this.currentWindow.onComplete();
                    this.currentWindow = null;
                }
            }
            finally {
                super.checkedComplete();
            }
        }

        @Override
        protected void firstCallback(T event) {
            this.subscriber.onNext(this.createWindowStream());
        }

        @Override
        protected void nextCallback(T event) {
            if (this.currentWindow != null) {
                this.currentWindow.onNext(event);
            }
        }

        @Override
        protected void flushCallback(T event) {
            if (this.currentWindow != null) {
                this.currentWindow.onComplete();
            }
        }

        @Override
        public Object connectedInput() {
            return this.currentWindow;
        }
    }

    static final class Window<T>
    extends Flux<T>
    implements Subscriber<T>,
    Subscription,
    Producer {
        protected final UnicastProcessor<T> processor = UnicastProcessor.create();
        protected final TimedScheduler timer;
        protected int count = 0;

        public Window(TimedScheduler timer) {
            this.timer = timer;
        }

        public void onSubscribe(Subscription s) {
            s.cancel();
        }

        public void onNext(T t) {
            ++this.count;
            this.processor.onNext(t);
        }

        public void onError(Throwable t) {
            this.processor.onError(t);
        }

        public void onComplete() {
            this.processor.onComplete();
        }

        public void subscribe(Subscriber<? super T> s) {
            this.processor.subscribe(s);
        }

        public void request(long n) {
        }

        public void cancel() {
        }

        @Override
        public Object downstream() {
            return this.processor;
        }
    }
}

