/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoCount<T>
extends MonoSource<T, Long>
implements Fuseable {
    public MonoCount(Publisher<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super Long> s) {
        this.source.subscribe(new CountSubscriber((Subscriber<? super Long>)((Subscriber<Long>)s)));
    }

    static final class CountSubscriber<T>
    extends Operators.MonoSubscriber<T, Long>
    implements Receiver {
        long counter;
        Subscription s;

        public CountSubscriber(Subscriber<? super Long> actual) {
            super(actual);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            ++this.counter;
        }

        @Override
        public void onComplete() {
            this.complete(this.counter);
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

