/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoStreamCollector<T, A, R>
extends MonoSource<T, R>
implements Fuseable {
    final Collector<T, A, R> collector;

    public MonoStreamCollector(Publisher<? extends T> source, Collector<T, A, R> collector) {
        super(source);
        this.collector = Objects.requireNonNull(collector, "collector");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        Function<A, R> finisher;
        BiConsumer<A, T> accumulator;
        A container;
        try {
            container = this.collector.supplier().get();
            accumulator = this.collector.accumulator();
            finisher = this.collector.finisher();
        }
        catch (Throwable ex) {
            Operators.error(s, Operators.onOperatorError(ex));
            return;
        }
        this.source.subscribe(new StreamCollectorSubscriber<T, A, R>(s, container, accumulator, finisher));
    }

    static final class StreamCollectorSubscriber<T, A, R>
    extends Operators.MonoSubscriber<T, R> {
        final BiConsumer<A, T> accumulator;
        final Function<A, R> finisher;
        A container;
        Subscription s;
        boolean done;

        public StreamCollectorSubscriber(Subscriber<? super R> actual, A container, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(actual);
            this.container = container;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                this.accumulator.accept(this.container, t);
            }
            catch (Throwable ex) {
                this.onError(Operators.onOperatorError(this.s, ex, t));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.container = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            R r;
            if (this.done) {
                return;
            }
            this.done = true;
            A a = this.container;
            this.container = null;
            try {
                r = this.finisher.apply(a);
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(ex));
                return;
            }
            this.complete(r);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

