/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoSubscribeOn<T>
extends MonoSource<T, T> {
    final Scheduler scheduler;

    public MonoSubscribeOn(Publisher<? extends T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        MonoSubscribeOnSubscriber<? super T> parent = new MonoSubscribeOnSubscriber<T>(s, worker);
        s.onSubscribe(parent);
        worker.schedule(() -> this.source.subscribe((Subscriber)parent));
    }

    static final class MonoSubscribeOnSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final Scheduler.Worker worker;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<MonoSubscribeOnSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(MonoSubscribeOnSubscriber.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<MonoSubscribeOnSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(MonoSubscribeOnSubscriber.class, "requested");

        public MonoSubscribeOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker) {
            this.actual = actual;
            this.worker = worker;
        }

        public void onSubscribe(Subscription s) {
            if (!Operators.setOnce(S, this, s)) {
                s.cancel();
            } else {
                long r = REQUESTED.getAndSet(this, 0L);
                if (r != 0L) {
                    this.worker.schedule(() -> this.requestMore(r));
                }
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            try {
                this.actual.onError(t);
            }
            finally {
                this.worker.shutdown();
            }
        }

        public void onComplete() {
            try {
                this.actual.onComplete();
            }
            finally {
                this.worker.shutdown();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                this.worker.schedule(() -> this.requestMore(n));
            }
        }

        public void cancel() {
            if (Operators.terminate(S, this)) {
                this.worker.shutdown();
            }
        }

        void requestMore(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            } else {
                long r;
                Operators.getAndAddCap(REQUESTED, this, n);
                a = this.s;
                if (a != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    a.request(r);
                }
            }
        }
    }
}

