/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.locks.LockSupport;
import reactor.core.publisher.AtomicSequence;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.RingBufferProducer;
import reactor.util.concurrent.WaitStrategy;

final class NotFunMultiProducer
extends RingBufferProducer {
    private final RingBuffer.Sequence gatingSequenceCache = new AtomicSequence(-1L);
    private final int[] availableBuffer;
    private final int indexMask;
    private final int indexShift;

    NotFunMultiProducer(int bufferSize, WaitStrategy waitStrategy, Runnable spinObserver) {
        super(bufferSize, waitStrategy, spinObserver);
        this.availableBuffer = new int[bufferSize];
        this.indexMask = bufferSize - 1;
        this.indexShift = RingBuffer.log2(bufferSize);
        this.initialiseAvailableBuffer();
    }

    private boolean hasAvailableCapacity(RingBuffer.Sequence[] gatingSequences, int requiredCapacity, long cursorValue) {
        long wrapPoint = cursorValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.gatingSequenceCache.getAsLong();
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > cursorValue) {
            long minSequence = RingBuffer.getMinimumSequence(gatingSequences, cursorValue);
            this.gatingSequenceCache.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long next() {
        return this.next(1);
    }

    @Override
    public long next(int n) {
        long next;
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        while (true) {
            long cachedGatingSequence;
            long current;
            long wrapPoint;
            if ((wrapPoint = (next = (current = this.cursor.getAsLong()) + (long)n) - (long)this.bufferSize) > (cachedGatingSequence = this.gatingSequenceCache.getAsLong()) || cachedGatingSequence > current) {
                long gatingSequence = RingBuffer.getMinimumSequence(this.gatingSequences, current);
                if (wrapPoint > gatingSequence) {
                    if (this.spinObserver != null) {
                        this.spinObserver.run();
                    }
                    LockSupport.parkNanos(1L);
                    continue;
                }
                this.gatingSequenceCache.set(gatingSequence);
                continue;
            }
            if (this.cursor.compareAndSet(current, next)) break;
        }
        return next;
    }

    @Override
    public long remainingCapacity() {
        return (long)this.getBufferSize() - this.getPending();
    }

    @Override
    public long getPending() {
        long consumed = RingBuffer.getMinimumSequence(this.gatingSequences, this.cursor.getAsLong());
        long produced = this.cursor.getAsLong();
        return produced - consumed;
    }

    private void initialiseAvailableBuffer() {
        for (int i = this.availableBuffer.length - 1; i != 0; --i) {
            this.setAvailableBufferValue(i, -1);
        }
        this.setAvailableBufferValue(0, -1);
    }

    @Override
    public void publish(long sequence) {
        this.setAvailable(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void publish(long lo, long hi) {
        for (long l = lo; l <= hi; ++l) {
            this.setAvailable(l);
        }
        this.waitStrategy.signalAllWhenBlocking();
    }

    private void setAvailable(long sequence) {
        this.setAvailableBufferValue(this.calculateIndex(sequence), this.calculateAvailabilityFlag(sequence));
    }

    private void setAvailableBufferValue(int index, int flag) {
        this.availableBuffer[index] = flag;
    }

    @Override
    public boolean isAvailable(long sequence) {
        int flag;
        int index = this.calculateIndex(sequence);
        return this.availableBuffer[index] == (flag = this.calculateAvailabilityFlag(sequence));
    }

    @Override
    public long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        for (long sequence = lowerBound; sequence <= availableSequence; ++sequence) {
            if (this.isAvailable(sequence)) continue;
            return sequence - 1L;
        }
        return availableSequence;
    }

    private int calculateAvailabilityFlag(long sequence) {
        return (int)(sequence >>> this.indexShift);
    }

    private int calculateIndex(long sequence) {
        return (int)sequence & this.indexMask;
    }
}

