/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.SerializedSubscriber;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class Operators {
    static final Logger log = Loggers.getLogger(Operators.class);

    public static long addAndGet(AtomicLong current, long toAdd) {
        long u;
        long r;
        do {
            if ((r = current.get()) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!current.compareAndSet(r, u = Operators.addCap(r, toAdd)));
        return u;
    }

    public static <T> long addAndGet(AtomicLongFieldUpdater<T> updater, T instance, long n) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!updater.compareAndSet(instance, r, u = Operators.addCap(r, n)));
        return r;
    }

    public static long addCap(long a, long b) {
        long res = a + b;
        if (res < 0L) {
            return Long.MAX_VALUE;
        }
        return res;
    }

    public static <T> Fuseable.QueueSubscription<T> as(Subscription s) {
        if (s instanceof Fuseable.QueueSubscription) {
            return (Fuseable.QueueSubscription)s;
        }
        return null;
    }

    public static Subscription cancelledSubscription() {
        return CancelledSubscription.INSTANCE;
    }

    public static void checkRequest(long n) throws IllegalArgumentException {
        if (n <= 0L) {
            throw Exceptions.nullOrNegativeRequestException(n);
        }
    }

    public static boolean checkRequest(long n, Subscriber<?> subscriber) {
        if (n <= 0L) {
            if (null == subscriber) {
                throw Exceptions.nullOrNegativeRequestException(n);
            }
            subscriber.onError((Throwable)Exceptions.nullOrNegativeRequestException(n));
            return false;
        }
        return true;
    }

    public static void complete(Subscriber<?> s) {
        s.onSubscribe((Subscription)EmptySubscription.INSTANCE);
        s.onComplete();
    }

    public static Subscription emptySubscription() {
        return EmptySubscription.INSTANCE;
    }

    public static void error(Subscriber<?> s, Throwable e) {
        s.onSubscribe((Subscription)EmptySubscription.INSTANCE);
        s.onError(e);
    }

    public static <T> long getAndAddCap(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!updater.compareAndSet(instance, r, u = Operators.addCap(r, toAdd)));
        return r;
    }

    public static <T> long produced(AtomicLongFieldUpdater<T> updater, T instance, long toSub) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != 0L && r != Long.MAX_VALUE) continue;
            return r;
        } while (!updater.compareAndSet(instance, r, u = Operators.subOrZero(r, toSub)));
        return u;
    }

    public static long multiplyCap(long a, long b) {
        long u = a * b;
        if ((a | b) >>> 31 != 0L && u / a != b) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static void onErrorDropped(Throwable e, Throwable root) {
        if (root != null) {
            e.addSuppressed(root);
        }
        Operators.onErrorDropped(e);
    }

    public static void onErrorDropped(Throwable e) {
        Consumer<? super Throwable> hook = Hooks.onErrorDroppedHook;
        if (hook == null) {
            throw Exceptions.bubble(e);
        }
        hook.accept(e);
    }

    public static <T> void onNextDropped(T t) {
        if (t != null) {
            Consumer<Object> hook = Hooks.onNextDroppedHook;
            if (hook == null) {
                throw Exceptions.failWithCancel();
            }
            hook.accept(t);
        }
    }

    public static Throwable onOperatorError(Throwable error) {
        return Operators.onOperatorError(null, error, null);
    }

    public static Throwable onOperatorError(Subscription subscription, Throwable error) {
        return Operators.onOperatorError(subscription, error, null);
    }

    public static Throwable onOperatorError(Subscription subscription, Throwable error, Object dataSignal) {
        Exceptions.throwIfFatal(error);
        if (subscription != null) {
            subscription.cancel();
        }
        Throwable t = Exceptions.unwrap(error);
        BiFunction<? super Throwable, Object, ? extends Throwable> hook = Hooks.onOperatorErrorHook;
        if (hook == null) {
            if (dataSignal != null && dataSignal instanceof Throwable) {
                t.addSuppressed((Throwable)dataSignal);
            }
            return t;
        }
        return hook.apply(error, dataSignal);
    }

    public static <F> boolean replace(AtomicReferenceFieldUpdater<F, Subscription> field, F instance, Subscription s) {
        Subscription a;
        do {
            if ((a = field.get(instance)) != CancelledSubscription.INSTANCE) continue;
            s.cancel();
            return false;
        } while (!field.compareAndSet(instance, a, s));
        return true;
    }

    public static void reportBadRequest(long n) {
        throw Exceptions.nullOrNegativeRequestException(n);
    }

    public static void reportMoreProduced() {
        throw Exceptions.failWithOverflow();
    }

    public static void reportSubscriptionSet() {
        if (log.isDebugEnabled()) {
            log.debug("Duplicate Subscription has been detected", Exceptions.duplicateOnSubscribeException());
        }
    }

    public static <F> boolean set(AtomicReferenceFieldUpdater<F, Subscription> field, F instance, Subscription s) {
        Subscription a;
        do {
            if ((a = field.get(instance)) != CancelledSubscription.INSTANCE) continue;
            s.cancel();
            return false;
        } while (!field.compareAndSet(instance, a, s));
        if (a != null) {
            a.cancel();
        }
        return true;
    }

    public static <F> boolean setOnce(AtomicReferenceFieldUpdater<F, Subscription> field, F instance, Subscription s) {
        Subscription a = field.get(instance);
        if (a == CancelledSubscription.INSTANCE) {
            s.cancel();
            return false;
        }
        if (a != null) {
            Operators.reportSubscriptionSet();
            return false;
        }
        if (field.compareAndSet(instance, null, s)) {
            return true;
        }
        a = field.get(instance);
        if (a == CancelledSubscription.INSTANCE) {
            s.cancel();
            return false;
        }
        s.cancel();
        Operators.reportSubscriptionSet();
        return false;
    }

    public static long subOrZero(long a, long b) {
        long res = a - b;
        if (res < 0L) {
            return 0L;
        }
        return res;
    }

    public static <F> boolean terminate(AtomicReferenceFieldUpdater<F, Subscription> field, F instance) {
        Subscription a = field.get(instance);
        if (a != CancelledSubscription.INSTANCE && (a = field.getAndSet(instance, CancelledSubscription.INSTANCE)) != null && a != CancelledSubscription.INSTANCE) {
            a.cancel();
            return true;
        }
        return false;
    }

    public static boolean validate(Subscription current, Subscription next) {
        Objects.requireNonNull(next, "Subscription cannot be null");
        if (current != null) {
            next.cancel();
            return false;
        }
        return true;
    }

    public static boolean validate(long n) {
        if (n < 0L) {
            Operators.reportBadRequest(n);
            return false;
        }
        return true;
    }

    public static <T> Subscription scalarSubscription(Subscriber<? super T> subscriber, T value) {
        return new ScalarSubscription<T>(subscriber, value);
    }

    public static <T> Subscriber<T> serialize(Subscriber<? super T> subscriber) {
        return new SerializedSubscriber<T>(subscriber);
    }

    Operators() {
    }

    static final class ScalarSubscription<T>
    implements Fuseable.QueueSubscription<T>,
    Producer,
    Receiver {
        final Subscriber<? super T> actual;
        final T value;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ScalarSubscription> ONCE = AtomicIntegerFieldUpdater.newUpdater(ScalarSubscription.class, "once");

        public ScalarSubscription(Subscriber<? super T> actual, T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.actual = Objects.requireNonNull(actual, "actual");
        }

        public final Subscriber<? super T> downstream() {
            return this.actual;
        }

        public void request(long n) {
            if (Operators.validate(n) && ONCE.compareAndSet(this, 0, 1)) {
                Subscriber<? super T> a = this.actual;
                a.onNext(this.value);
                if (this.once != 2) {
                    a.onComplete();
                }
            }
        }

        public void cancel() {
            ONCE.lazySet(this, 2);
        }

        @Override
        public Object upstream() {
            return this.value;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public T poll() {
            if (this.once == 0) {
                ONCE.lazySet(this, 1);
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.once != 0;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public void clear() {
            ONCE.lazySet(this, 1);
        }
    }

    static abstract class MultiSubscriptionSubscriber<I, O>
    implements Subscription,
    Subscriber<I>,
    Producer,
    Trackable,
    Receiver {
        protected final Subscriber<? super O> subscriber;
        Subscription actual;
        long requested;
        volatile Subscription missedSubscription;
        static final AtomicReferenceFieldUpdater<MultiSubscriptionSubscriber, Subscription> MISSED_SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, Subscription.class, "missedSubscription");
        volatile long missedRequested;
        static final AtomicLongFieldUpdater<MultiSubscriptionSubscriber> MISSED_REQUESTED = AtomicLongFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, "missedRequested");
        volatile long missedProduced;
        static final AtomicLongFieldUpdater<MultiSubscriptionSubscriber> MISSED_PRODUCED = AtomicLongFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, "missedProduced");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<MultiSubscriptionSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, "wip");
        volatile boolean cancelled;
        protected boolean unbounded;

        public MultiSubscriptionSubscriber(Subscriber<? super O> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription s) {
            this.set(s);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public final void set(Subscription s) {
            if (this.cancelled) {
                s.cancel();
                return;
            }
            Objects.requireNonNull(s);
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                Subscription a = this.actual;
                if (a != null && this.shouldCancelCurrent()) {
                    a.cancel();
                }
                this.actual = s;
                long r = this.requested;
                if (WIP.decrementAndGet(this) != 0) {
                    this.drainLoop();
                }
                if (r != 0L) {
                    s.request(r);
                }
                return;
            }
            Subscription a = MISSED_SUBSCRIPTION.getAndSet(this, s);
            if (a != null && this.shouldCancelCurrent()) {
                a.cancel();
            }
            this.drain();
        }

        public final void request(long n) {
            if (Operators.validate(n)) {
                if (this.unbounded) {
                    return;
                }
                if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                    long r = this.requested;
                    if (r != Long.MAX_VALUE) {
                        this.requested = r = Operators.addCap(r, n);
                        if (r == Long.MAX_VALUE) {
                            this.unbounded = true;
                        }
                    }
                    Subscription a = this.actual;
                    if (WIP.decrementAndGet(this) != 0) {
                        this.drainLoop();
                    }
                    if (a != null) {
                        a.request(n);
                    }
                    return;
                }
                Operators.getAndAddCap(MISSED_REQUESTED, this, n);
                this.drain();
            }
        }

        public final void producedOne() {
            if (this.unbounded) {
                return;
            }
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                long r = this.requested;
                if (r != Long.MAX_VALUE) {
                    if (--r < 0L) {
                        Operators.reportMoreProduced();
                        r = 0L;
                    }
                    this.requested = r;
                } else {
                    this.unbounded = true;
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
                this.drainLoop();
                return;
            }
            Operators.getAndAddCap(MISSED_PRODUCED, this, 1L);
            this.drain();
        }

        public final void produced(long n) {
            if (this.unbounded) {
                return;
            }
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                long r = this.requested;
                if (r != Long.MAX_VALUE) {
                    long u = r - n;
                    if (u < 0L) {
                        Operators.reportMoreProduced();
                        u = 0L;
                    }
                    this.requested = u;
                } else {
                    this.unbounded = true;
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
                this.drainLoop();
                return;
            }
            Operators.getAndAddCap(MISSED_PRODUCED, this, n);
            this.drain();
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.drain();
            }
        }

        @Override
        public final boolean isCancelled() {
            return this.cancelled;
        }

        final void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            this.drainLoop();
        }

        final void drainLoop() {
            int missed = 1;
            long requestAmount = 0L;
            Subscription requestTarget = null;
            do {
                long mp;
                long mr;
                Subscription ms;
                if ((ms = this.missedSubscription) != null) {
                    ms = MISSED_SUBSCRIPTION.getAndSet(this, null);
                }
                if ((mr = this.missedRequested) != 0L) {
                    mr = MISSED_REQUESTED.getAndSet(this, 0L);
                }
                if ((mp = this.missedProduced) != 0L) {
                    mp = MISSED_PRODUCED.getAndSet(this, 0L);
                }
                Subscription a = this.actual;
                if (this.cancelled) {
                    if (a != null) {
                        a.cancel();
                        this.actual = null;
                    }
                    if (ms == null) continue;
                    ms.cancel();
                    continue;
                }
                long r = this.requested;
                if (r != Long.MAX_VALUE) {
                    long u = Operators.addCap(r, mr);
                    if (u != Long.MAX_VALUE) {
                        long v = u - mp;
                        if (v < 0L) {
                            Operators.reportMoreProduced();
                            v = 0L;
                        }
                        r = v;
                    } else {
                        r = u;
                    }
                    this.requested = r;
                }
                if (ms != null) {
                    if (a != null && this.shouldCancelCurrent()) {
                        a.cancel();
                    }
                    this.actual = ms;
                    if (r == 0L) continue;
                    requestAmount = Operators.addCap(requestAmount, r);
                    requestTarget = ms;
                    continue;
                }
                if (mr == 0L || a == null) continue;
                requestAmount = Operators.addCap(requestAmount, mr);
                requestTarget = a;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            if (requestAmount != 0L) {
                requestTarget.request(requestAmount);
            }
        }

        public final Subscriber<? super O> downstream() {
            return this.subscriber;
        }

        public final Subscription upstream() {
            return this.actual != null ? this.actual : this.missedSubscription;
        }

        @Override
        public final long requestedFromDownstream() {
            return this.requested + this.missedRequested;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean isStarted() {
            return this.upstream() != null;
        }

        public final boolean isUnbounded() {
            return this.unbounded;
        }

        protected boolean shouldCancelCurrent() {
            return false;
        }
    }

    public static class SubscriberAdapter<I, O>
    implements Subscriber<I>,
    Subscription,
    Trackable,
    Receiver,
    Producer {
        protected final Subscriber<? super O> subscriber;
        protected Subscription subscription;

        public SubscriberAdapter(Subscriber<? super O> subscriber) {
            this.subscriber = subscriber;
        }

        public Subscription upstream() {
            return this.subscription;
        }

        @Override
        public boolean isStarted() {
            return this.subscription != null;
        }

        public Subscriber<? super O> downstream() {
            return this.subscriber;
        }

        public final void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                try {
                    this.subscription = s;
                    this.doOnSubscribe(s);
                }
                catch (Throwable throwable) {
                    this.doOnSubscriberError(Operators.onOperatorError(s, throwable));
                }
            }
        }

        protected void doOnSubscribe(Subscription subscription) {
            this.subscriber.onSubscribe((Subscription)this);
        }

        public final void onNext(I i) {
            if (i == null) {
                throw Exceptions.argumentIsNullException();
            }
            try {
                this.doNext(i);
            }
            catch (Throwable throwable) {
                this.doOnSubscriberError(Operators.onOperatorError(this.subscription, throwable, i));
            }
        }

        protected void doNext(I i) {
            this.subscriber.onNext(i);
        }

        public final void onError(Throwable t) {
            if (t == null) {
                throw Exceptions.argumentIsNullException();
            }
            this.doError(t);
        }

        protected void doError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        protected void doOnSubscriberError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        public final void onComplete() {
            try {
                this.doComplete();
            }
            catch (Throwable throwable) {
                this.doOnSubscriberError(Operators.onOperatorError(throwable));
            }
        }

        protected void doComplete() {
            this.subscriber.onComplete();
        }

        public final void request(long n) {
            try {
                Operators.checkRequest(n);
                this.doRequest(n);
            }
            catch (Throwable throwable) {
                this.doCancel();
                this.doOnSubscriberError(Operators.onOperatorError(throwable));
            }
        }

        protected void doRequest(long n) {
            Subscription s = this.subscription;
            if (s != null) {
                s.request(n);
            }
        }

        public final void cancel() {
            try {
                this.doCancel();
            }
            catch (Throwable throwable) {
                this.doOnSubscriberError(Operators.onOperatorError(this.subscription, throwable));
            }
        }

        protected void doCancel() {
            Subscription s = this.subscription;
            if (s != null) {
                this.subscription = null;
                s.cancel();
            }
        }

        @Override
        public boolean isTerminated() {
            return null != this.subscription && this.subscription instanceof Trackable && ((Trackable)this.subscription).isTerminated();
        }

        @Override
        public long getCapacity() {
            return this.subscriber != null && Trackable.class.isAssignableFrom(this.subscriber.getClass()) ? ((Trackable)this.subscriber).getCapacity() : Long.MAX_VALUE;
        }

        @Override
        public long getPending() {
            return this.subscriber != null && Trackable.class.isAssignableFrom(this.subscriber.getClass()) ? ((Trackable)this.subscriber).getPending() : -1L;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class MonoSubscriber<I, O>
    implements Subscriber<I>,
    Loopback,
    Trackable,
    Receiver,
    Producer,
    Fuseable,
    Fuseable.QueueSubscription<O> {
        protected final Subscriber<? super O> actual;
        protected O value;
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;
        static final int CANCELLED = 4;
        static final int FUSED_EMPTY = 8;
        static final int FUSED_READY = 16;
        static final int FUSED_CONSUMED = 32;
        volatile int state;
        static final AtomicIntegerFieldUpdater<MonoSubscriber> STATE = AtomicIntegerFieldUpdater.newUpdater(MonoSubscriber.class, "state");

        public MonoSubscriber(Subscriber<? super O> actual) {
            this.actual = actual;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                do {
                    O v;
                    int s;
                    if (((s = this.state) & 0xFFFFFFFE) != 0) {
                        return;
                    }
                    if (s != 1) continue;
                    if (STATE.compareAndSet(this, 1, 3) && (v = this.value) != null) {
                        this.value = null;
                        Subscriber<? super O> a = this.actual;
                        a.onNext(v);
                        if (this.state != 4) {
                            a.onComplete();
                        }
                    }
                    return;
                } while (!STATE.compareAndSet(this, 0, 2));
                return;
            }
        }

        public void cancel() {
            this.state = 4;
            this.value = null;
        }

        public void onNext(I t) {
            this.setValue(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onSubscribe(Subscription s) {
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public final boolean isCancelled() {
            return this.state == 4;
        }

        public final Subscriber<? super O> downstream() {
            return this.actual;
        }

        public void setValue(O value) {
            this.value = value;
        }

        public final void complete(O v) {
            int state = this.state;
            do {
                if (state == 8) {
                    this.setValue(v);
                    STATE.lazySet(this, 16);
                    Subscriber<? super O> a = this.actual;
                    a.onNext(v);
                    if (this.state != 4) {
                        a.onComplete();
                    }
                    return;
                }
                if ((state & 0xFFFFFFFD) != 0) {
                    return;
                }
                if (state == 2) {
                    STATE.lazySet(this, 3);
                    Subscriber<? super O> a = this.actual;
                    a.onNext(v);
                    if (this.state != 4) {
                        a.onComplete();
                    }
                    return;
                }
                this.setValue(v);
                if (!STATE.compareAndSet(this, 0, 1)) continue;
                return;
            } while ((state = this.state) != 4);
            this.value = null;
        }

        @Override
        public boolean isStarted() {
            return this.state != 0;
        }

        @Override
        public Object connectedOutput() {
            return this.value;
        }

        @Override
        public boolean isTerminated() {
            return this.isCancelled();
        }

        @Override
        public Object upstream() {
            return this.value;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                STATE.lazySet(this, 8);
                return 2;
            }
            return 0;
        }

        @Override
        public final O poll() {
            if (STATE.get(this) == 16) {
                STATE.lazySet(this, 32);
                O v = this.value;
                this.value = null;
                return v;
            }
            return null;
        }

        @Override
        public final boolean isEmpty() {
            return this.state != 16;
        }

        @Override
        public final void clear() {
            STATE.lazySet(this, 32);
            this.value = null;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }
    }

    public static class DeferredSubscription
    implements Subscription,
    Receiver,
    Trackable {
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<DeferredSubscription, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(DeferredSubscription.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<DeferredSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(DeferredSubscription.class, "requested");

        public final boolean set(Subscription s) {
            Objects.requireNonNull(s, "s");
            Subscription a = this.s;
            if (a == Operators.cancelledSubscription()) {
                s.cancel();
                return false;
            }
            if (a != null) {
                s.cancel();
                Operators.reportSubscriptionSet();
                return false;
            }
            if (S.compareAndSet(this, null, s)) {
                long r = REQUESTED.getAndSet(this, 0L);
                if (r != 0L) {
                    s.request(r);
                }
                return true;
            }
            a = this.s;
            if (a != Operators.cancelledSubscription()) {
                s.cancel();
                return false;
            }
            Operators.reportSubscriptionSet();
            return false;
        }

        public void request(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            } else {
                long r;
                Operators.addAndGet(REQUESTED, this, n);
                a = this.s;
                if (a != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    a.request(r);
                }
            }
        }

        public void cancel() {
            Subscription a = this.s;
            if (a != Operators.cancelledSubscription() && (a = S.getAndSet(this, Operators.cancelledSubscription())) != null && a != Operators.cancelledSubscription()) {
                a.cancel();
            }
        }

        @Override
        public final boolean isCancelled() {
            return this.s == Operators.cancelledSubscription();
        }

        @Override
        public final boolean isStarted() {
            return this.s != null;
        }

        @Override
        public final boolean isTerminated() {
            return this.isCancelled();
        }

        @Override
        public final long requestedFromDownstream() {
            return this.requested;
        }

        public Subscription upstream() {
            return this.s;
        }
    }

    static enum EmptySubscription implements Fuseable.QueueSubscription<Object>
    {
        INSTANCE;


        public void cancel() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Object poll() {
            return null;
        }

        public void request(long n) {
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static enum CancelledSubscription implements Subscription,
    Trackable
    {
        INSTANCE;


        public void cancel() {
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        public void request(long n) {
        }
    }
}

