/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxConcatMap;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.LambdaSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelCollect;
import reactor.core.publisher.ParallelFlatMap;
import reactor.core.publisher.ParallelFluxHide;
import reactor.core.publisher.ParallelGroup;
import reactor.core.publisher.ParallelReduce;
import reactor.core.publisher.ParallelReduceFull;
import reactor.core.publisher.ParallelSortedJoin;
import reactor.core.publisher.ParallelUnorderedConcatMap;
import reactor.core.publisher.ParallelUnorderedFilter;
import reactor.core.publisher.ParallelUnorderedFrom;
import reactor.core.publisher.ParallelUnorderedJoin;
import reactor.core.publisher.ParallelUnorderedMap;
import reactor.core.publisher.ParallelUnorderedPeek;
import reactor.core.publisher.ParallelUnorderedRunOn;
import reactor.core.publisher.ParallelUnorderedSource;
import reactor.core.publisher.SignalLogger;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.util.concurrent.QueueSupplier;

public abstract class ParallelFlux<T>
implements Publisher<T> {
    public static <T> ParallelFlux<T> from(Publisher<? extends T> source) {
        return ParallelFlux.from(source, Runtime.getRuntime().availableProcessors(), QueueSupplier.SMALL_BUFFER_SIZE, QueueSupplier.small());
    }

    public static <T> ParallelFlux<T> from(Publisher<? extends T> source, int parallelism) {
        return ParallelFlux.from(source, parallelism, QueueSupplier.SMALL_BUFFER_SIZE, QueueSupplier.small());
    }

    public static <T> ParallelFlux<T> from(Publisher<? extends T> source, int parallelism, int prefetch, Supplier<Queue<T>> queueSupplier) {
        if (parallelism <= 0) {
            throw new IllegalArgumentException("parallelism > 0 required but it was " + parallelism);
        }
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        Objects.requireNonNull(queueSupplier, "queueSupplier");
        Objects.requireNonNull(source, "queueSupplier");
        return ParallelFlux.onAssembly(new ParallelUnorderedSource<T>(source, parallelism, prefetch, queueSupplier));
    }

    @SafeVarargs
    public static <T> ParallelFlux<T> from(Publisher<T> ... publishers) {
        if (publishers.length == 0) {
            throw new IllegalArgumentException("Zero publishers not supported");
        }
        return ParallelFlux.onAssembly(new ParallelUnorderedFrom<T>(publishers));
    }

    public final <U> U as(Function<? super ParallelFlux<T>, U> converter) {
        return converter.apply(this);
    }

    public final <C> ParallelFlux<C> collect(Supplier<C> collectionSupplier, BiConsumer<C, T> collector) {
        return ParallelFlux.onAssembly(new ParallelCollect<T, C>(this, collectionSupplier, collector));
    }

    public final Mono<List<T>> collectSortedList(Comparator<? super T> comparator) {
        return this.collectSortedList(comparator, 16);
    }

    public final Mono<List<T>> collectSortedList(Comparator<? super T> comparator, int capacityHint) {
        int ch = capacityHint / this.parallelism() + 1;
        ParallelFlux<List> railReduced = this.reduce(() -> new ArrayList(ch), (a, b) -> {
            a.add(b);
            return a;
        });
        ParallelFlux<List> railSorted = railReduced.map(list -> {
            list.sort(comparator);
            return list;
        });
        Mono<List<T>> merged = railSorted.reduce((a, b) -> {
            ArrayList both;
            block6: {
                Object s2;
                Iterator bt;
                block5: {
                    int n = a.size() + b.size();
                    if (n == 0) {
                        return new ArrayList();
                    }
                    both = new ArrayList(n);
                    Iterator at = a.iterator();
                    bt = b.iterator();
                    Object s1 = at.hasNext() ? at.next() : null;
                    Object v0 = s2 = bt.hasNext() ? bt.next() : null;
                    while (s1 != null && s2 != null) {
                        if (comparator.compare(s1, s2) < 0) {
                            both.add(s1);
                            s1 = at.hasNext() ? at.next() : null;
                            continue;
                        }
                        both.add(s2);
                        s2 = bt.hasNext() ? bt.next() : null;
                    }
                    if (s1 == null) break block5;
                    both.add(s1);
                    while (at.hasNext()) {
                        both.add(at.next());
                    }
                    break block6;
                }
                if (s2 == null) break block6;
                both.add(s2);
                while (bt.hasNext()) {
                    both.add(bt.next());
                }
            }
            return both;
        });
        return merged;
    }

    public final <R> ParallelFlux<R> concatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMap(mapper, 2, FluxConcatMap.ErrorMode.IMMEDIATE);
    }

    public final <R> ParallelFlux<R> concatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
        return this.concatMap(mapper, prefetch, FluxConcatMap.ErrorMode.IMMEDIATE);
    }

    public final <R> ParallelFlux<R> concatMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMap(mapper, 2, FluxConcatMap.ErrorMode.END);
    }

    public final ParallelFlux<T> doAfterTerminate(Runnable afterTerminate) {
        Objects.requireNonNull(afterTerminate, "afterTerminate");
        return ParallelFlux.doOnSignal(this, null, null, null, null, afterTerminate, null, null, null);
    }

    public final ParallelFlux<T> doOnCancel(Runnable onCancel) {
        Objects.requireNonNull(onCancel, "onCancel");
        return ParallelFlux.doOnSignal(this, null, null, null, null, null, null, null, onCancel);
    }

    public final ParallelFlux<T> doOnComplete(Runnable onComplete) {
        Objects.requireNonNull(onComplete, "onComplete");
        return ParallelFlux.doOnSignal(this, null, null, null, onComplete, null, null, null, null);
    }

    public final ParallelFlux<T> doOnError(Consumer<? super Throwable> onError) {
        Objects.requireNonNull(onError, "onError");
        return ParallelFlux.doOnSignal(this, null, null, onError, null, null, null, null, null);
    }

    public final ParallelFlux<T> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe");
        return ParallelFlux.doOnSignal(this, null, null, null, null, null, onSubscribe, null, null);
    }

    public final ParallelFlux<T> doOnNext(Consumer<? super T> onNext) {
        Objects.requireNonNull(onNext, "onNext");
        return ParallelFlux.doOnSignal(this, onNext, null, null, null, null, null, null, null);
    }

    public final ParallelFlux<T> doOnRequest(LongConsumer onRequest) {
        Objects.requireNonNull(onRequest, "onRequest");
        return ParallelFlux.doOnSignal(this, null, null, null, null, null, null, onRequest, null);
    }

    public final ParallelFlux<T> doOnTerminate(Runnable onTerminate) {
        Objects.requireNonNull(onTerminate, "onTerminate");
        return ParallelFlux.doOnSignal(this, null, null, e -> onTerminate.run(), onTerminate, null, null, null, null);
    }

    public final ParallelFlux<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        return ParallelFlux.onAssembly(new ParallelUnorderedFilter<T>(this, predicate));
    }

    public final <R> ParallelFlux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.flatMap(mapper, false, Integer.MAX_VALUE, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final <R> ParallelFlux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError) {
        return this.flatMap(mapper, delayError, Integer.MAX_VALUE, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final <R> ParallelFlux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency) {
        return this.flatMap(mapper, delayError, maxConcurrency, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final <R> ParallelFlux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, int prefetch) {
        return ParallelFlux.onAssembly(new ParallelFlatMap(this, mapper, delayError, maxConcurrency, QueueSupplier.get(maxConcurrency), prefetch, QueueSupplier.get(prefetch)));
    }

    public final Flux<GroupedFlux<Integer, T>> groups() {
        return Flux.onAssembly(new ParallelGroup(this));
    }

    public final ParallelFlux<T> hide() {
        return new ParallelFluxHide(this);
    }

    public abstract boolean isOrdered();

    public final ParallelFlux<T> log() {
        return this.log(null, Level.INFO, new SignalType[0]);
    }

    public final ParallelFlux<T> log(String category) {
        return this.log(category, Level.INFO, new SignalType[0]);
    }

    public final ParallelFlux<T> log(String category, Level level, SignalType ... options) {
        return this.log(category, level, false, options);
    }

    public final ParallelFlux<T> log(String category, Level level, boolean showOperatorLine, SignalType ... options) {
        SignalLogger log = new SignalLogger(this, category, level, showOperatorLine, options);
        return ParallelFlux.doOnSignal(this, log.onNextCall(), log.onAfterNextCall(), log.onErrorCall(), log.onCompleteCall(), log.onAfterTerminateCall(), log.onSubscribeCall(), log.onRequestCall(), log.onCancelCall());
    }

    public final <U> ParallelFlux<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return ParallelFlux.onAssembly(new ParallelUnorderedMap<T, U>(this, mapper));
    }

    public abstract int parallelism();

    public final Mono<T> reduce(BiFunction<T, T, T> reducer) {
        Objects.requireNonNull(reducer, "reducer");
        return Mono.onAssembly(new ParallelReduceFull<T>(this, reducer));
    }

    public final <R> ParallelFlux<R> reduce(Supplier<R> initialSupplier, BiFunction<R, T, R> reducer) {
        Objects.requireNonNull(initialSupplier, "initialSupplier");
        Objects.requireNonNull(reducer, "reducer");
        return ParallelFlux.onAssembly(new ParallelReduce<T, R>(this, initialSupplier, reducer));
    }

    public final ParallelFlux<T> runOn(Scheduler scheduler) {
        return this.runOn(scheduler, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final ParallelFlux<T> runOn(Scheduler scheduler, int prefetch) {
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        Objects.requireNonNull(scheduler, "scheduler");
        return ParallelFlux.onAssembly(new ParallelUnorderedRunOn(this, scheduler, prefetch, QueueSupplier.get(prefetch)));
    }

    public final Flux<T> sequential() {
        return this.sequential(QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final Flux<T> sequential(int prefetch) {
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        return Flux.onAssembly(new ParallelUnorderedJoin(this, prefetch, QueueSupplier.get(prefetch)));
    }

    public final Flux<T> sorted(Comparator<? super T> comparator) {
        return this.sorted(comparator, 16);
    }

    public final Flux<T> sorted(Comparator<? super T> comparator, int capacityHint) {
        int ch = capacityHint / this.parallelism() + 1;
        ParallelFlux<List> railReduced = this.reduce(() -> new ArrayList(ch), (a, b) -> {
            a.add(b);
            return a;
        });
        ParallelFlux railSorted = railReduced.map(list -> {
            list.sort(comparator);
            return list;
        });
        return Flux.onAssembly(new ParallelSortedJoin<T>(railSorted, comparator));
    }

    public abstract void subscribe(Subscriber<? super T>[] var1);

    public void subscribe(Consumer<? super T> onNext) {
        this.subscribe(onNext, null, null);
    }

    public void subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError) {
        this.subscribe(onNext, onError, null);
    }

    public void subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Runnable onComplete) {
        this.subscribe(onNext, onError, onComplete, null);
    }

    public void subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Runnable onComplete, Consumer<? super Subscription> onSubscribe) {
        Subscriber[] subscribers = new Subscriber[this.parallelism()];
        int i = 0;
        while (i < subscribers.length) {
            subscribers[i++] = new LambdaSubscriber<T>(onNext, onError, onComplete, onSubscribe);
        }
        this.subscribe(subscribers);
    }

    public final <U> ParallelFlux<U> transform(Function<? super ParallelFlux<T>, ParallelFlux<U>> composer) {
        return this.as(composer);
    }

    protected final boolean validate(Subscriber<?>[] subscribers) {
        int p = this.parallelism();
        if (subscribers.length != p) {
            for (Subscriber<?> s : subscribers) {
                Operators.error(s, new IllegalArgumentException("parallelism = " + p + ", subscribers = " + subscribers.length));
            }
            return false;
        }
        return true;
    }

    final <R> ParallelFlux<R> concatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, FluxConcatMap.ErrorMode errorMode) {
        return ParallelFlux.onAssembly(new ParallelUnorderedConcatMap(this, mapper, QueueSupplier.get(prefetch), prefetch, errorMode));
    }

    final <R> ParallelFlux<R> concatMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayUntilEnd, int prefetch) {
        return this.concatMap(mapper, prefetch, delayUntilEnd ? FluxConcatMap.ErrorMode.END : FluxConcatMap.ErrorMode.BOUNDARY);
    }

    final <R> ParallelFlux<R> concatMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
        return this.concatMap(mapper, prefetch, FluxConcatMap.ErrorMode.END);
    }

    public long getPrefetch() {
        return -1L;
    }

    public final void subscribe(Subscriber<? super T> s) {
        this.sequential().subscribe(s);
    }

    protected static <T> ParallelFlux<T> onAssembly(ParallelFlux<T> source) {
        Hooks.OnOperatorCreate<?> hook = Hooks.onOperatorCreate;
        if (hook == null) {
            return source;
        }
        return (ParallelFlux)hook.apply((Publisher<?>)source);
    }

    static <T> ParallelFlux<T> doOnSignal(ParallelFlux<T> source, Consumer<? super T> onNext, Consumer<? super T> onAfterNext, Consumer<? super Throwable> onError, Runnable onComplete, Runnable onAfterTerminate, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Runnable onCancel) {
        return ParallelFlux.onAssembly(new ParallelUnorderedPeek<T>(source, onNext, onAfterNext, onError, onComplete, onAfterTerminate, onSubscribe, onRequest, onCancel));
    }
}

