/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

final class ParallelReduceFull<T>
extends Mono<T>
implements Fuseable {
    final ParallelFlux<? extends T> source;
    final BiFunction<T, T, T> reducer;

    public ParallelReduceFull(ParallelFlux<? extends T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    public void subscribe(Subscriber<? super T> s) {
        ParallelReduceFullMainSubscriber<? super T> parent = new ParallelReduceFullMainSubscriber<T>(s, this.source.parallelism(), this.reducer);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SlotPair<T> {
        T first;
        T second;
        volatile int acquireIndex;
        static final AtomicIntegerFieldUpdater<SlotPair> ACQ = AtomicIntegerFieldUpdater.newUpdater(SlotPair.class, "acquireIndex");
        volatile int releaseIndex;
        static final AtomicIntegerFieldUpdater<SlotPair> REL = AtomicIntegerFieldUpdater.newUpdater(SlotPair.class, "releaseIndex");

        SlotPair() {
        }

        int tryAcquireSlot() {
            int acquired;
            do {
                if ((acquired = this.acquireIndex) < 2) continue;
                return -1;
            } while (!ACQ.compareAndSet(this, acquired, acquired + 1));
            return acquired;
        }

        boolean releaseSlot() {
            return REL.incrementAndGet(this) == 2;
        }
    }

    static final class ParallelReduceFullInnerSubscriber<T>
    implements Subscriber<T> {
        final ParallelReduceFullMainSubscriber<T> parent;
        final BiFunction<T, T, T> reducer;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ParallelReduceFullInnerSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ParallelReduceFullInnerSubscriber.class, Subscription.class, "s");
        T value;
        boolean done;

        public ParallelReduceFullInnerSubscriber(ParallelReduceFullMainSubscriber<T> parent, BiFunction<T, T, T> reducer) {
            this.parent = parent;
            this.reducer = reducer;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            T v = this.value;
            if (v == null) {
                this.value = t;
            } else {
                try {
                    v = this.reducer.apply(v, t);
                }
                catch (Throwable ex) {
                    this.onError(Operators.onOperatorError(this.s, ex, t));
                    return;
                }
                if (v == null) {
                    this.onError(Operators.onOperatorError(this.s, new NullPointerException("The reducer returned a null value"), t));
                    return;
                }
                this.value = v;
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.parent.innerError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.innerComplete(this.value);
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class ParallelReduceFullMainSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final ParallelReduceFullInnerSubscriber<T>[] subscribers;
        final BiFunction<T, T, T> reducer;
        volatile SlotPair<T> current;
        static final AtomicReferenceFieldUpdater<ParallelReduceFullMainSubscriber, SlotPair> CURRENT = AtomicReferenceFieldUpdater.newUpdater(ParallelReduceFullMainSubscriber.class, SlotPair.class, "current");
        volatile int remaining;
        static final AtomicIntegerFieldUpdater<ParallelReduceFullMainSubscriber> REMAINING = AtomicIntegerFieldUpdater.newUpdater(ParallelReduceFullMainSubscriber.class, "remaining");
        volatile int errorOnce;
        static final AtomicIntegerFieldUpdater<ParallelReduceFullMainSubscriber> ERROR_ONCE = AtomicIntegerFieldUpdater.newUpdater(ParallelReduceFullMainSubscriber.class, "errorOnce");

        public ParallelReduceFullMainSubscriber(Subscriber<? super T> subscriber, int n, BiFunction<T, T, T> reducer) {
            super(subscriber);
            ParallelReduceFullInnerSubscriber[] a = new ParallelReduceFullInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new ParallelReduceFullInnerSubscriber<T>(this, reducer);
            }
            this.subscribers = a;
            this.reducer = reducer;
            REMAINING.lazySet(this, n);
        }

        SlotPair<T> addValue(T value) {
            int c;
            SlotPair<T> curr;
            while (true) {
                if ((curr = this.current) == null && !CURRENT.compareAndSet(this, null, curr = new SlotPair())) {
                    continue;
                }
                c = curr.tryAcquireSlot();
                if (c >= 0) break;
                CURRENT.compareAndSet(this, curr, null);
            }
            if (c == 0) {
                curr.first = value;
            } else {
                curr.second = value;
            }
            if (curr.releaseSlot()) {
                CURRENT.compareAndSet(this, curr, null);
                return curr;
            }
            return null;
        }

        @Override
        public void cancel() {
            for (ParallelReduceFullInnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        void innerError(Throwable ex) {
            if (ERROR_ONCE.compareAndSet(this, 0, 1)) {
                this.cancel();
                this.actual.onError(ex);
            } else {
                Operators.onErrorDropped(ex);
            }
        }

        void innerComplete(T value) {
            SlotPair<T> sp;
            if (value != null) {
                while ((sp = this.addValue(value)) != null) {
                    try {
                        value = this.reducer.apply(sp.first, sp.second);
                    }
                    catch (Throwable ex) {
                        this.innerError(Operators.onOperatorError(this, ex));
                        return;
                    }
                    if (value != null) continue;
                    this.innerError(new NullPointerException("The reducer returned a null value"));
                    return;
                }
            }
            if (REMAINING.decrementAndGet(this) == 0) {
                sp = this.current;
                CURRENT.lazySet(this, null);
                if (sp != null) {
                    this.complete(sp.first);
                } else {
                    this.actual.onComplete();
                }
            }
        }
    }
}

