/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.SignalType;

public final class Signal<T>
implements Supplier<T>,
Consumer<Subscriber<? super T>>,
Serializable {
    private static final long serialVersionUID = 8430680363917273272L;
    private static final Signal<Void> ON_COMPLETE = new Signal<Object>(SignalType.ON_COMPLETE, null, null, null);
    private final SignalType type;
    private final Throwable throwable;
    private final T value;
    private final transient Subscription subscription;

    public static <T> Signal<T> complete() {
        return ON_COMPLETE;
    }

    public static <T> Signal<T> error(Throwable e) {
        return new Signal<Object>(SignalType.ON_ERROR, null, e, null);
    }

    public static <T> Signal<T> next(T t) {
        return new Signal<T>(SignalType.ON_NEXT, t, null, null);
    }

    public static boolean isComplete(Object o) {
        return o == ON_COMPLETE;
    }

    public static boolean isError(Object o) {
        return o instanceof Signal && ((Signal)o).type == SignalType.ON_ERROR;
    }

    public static <T> Signal<T> subscribe(Subscription subscription) {
        return new Signal<Object>(SignalType.ON_SUBSCRIBE, null, null, subscription);
    }

    private Signal(SignalType type, T value, Throwable e, Subscription subscription) {
        this.value = value;
        this.subscription = subscription;
        this.throwable = e;
        this.type = type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public T get() {
        return this.value;
    }

    public boolean hasValue() {
        return this.isOnNext() && this.value != null;
    }

    public boolean hasError() {
        return this.isOnError() && this.throwable != null;
    }

    public SignalType getType() {
        return this.type;
    }

    public boolean isOnError() {
        return this.getType() == SignalType.ON_ERROR;
    }

    public boolean isOnComplete() {
        return this.getType() == SignalType.ON_COMPLETE;
    }

    public boolean isOnSubscribe() {
        return this.getType() == SignalType.ON_SUBSCRIBE;
    }

    public boolean isOnNext() {
        return this.getType() == SignalType.ON_NEXT;
    }

    @Override
    public void accept(Subscriber<? super T> observer) {
        if (this.isOnNext()) {
            observer.onNext(this.get());
        } else if (this.isOnComplete()) {
            observer.onComplete();
        } else if (this.isOnError()) {
            observer.onError(this.getThrowable());
        } else if (this.isOnSubscribe()) {
            observer.onSubscribe(this.subscription);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signal signal = (Signal)o;
        if (this.type != signal.type) {
            return false;
        }
        if (this.isOnComplete()) {
            return true;
        }
        if (this.isOnSubscribe()) {
            return Objects.equals(this.subscription, signal.subscription);
        }
        if (this.isOnError()) {
            return Objects.equals(this.throwable, signal.throwable);
        }
        if (this.isOnNext()) {
            return Objects.equals(this.value, signal.value);
        }
        return false;
    }

    public int hashCode() {
        int result;
        int n = result = this.type != null ? this.type.hashCode() : 0;
        if (this.isOnError()) {
            result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        }
        if (this.isOnNext()) {
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        }
        if (this.isOnComplete()) {
            result = 31 * result + (this.subscription != null ? this.subscription.hashCode() : 0);
        }
        return result;
    }

    public String toString() {
        switch (this.type) {
            case ON_SUBSCRIBE: {
                return String.format("onSubscribe(%s)", this.subscription);
            }
            case ON_NEXT: {
                return String.format("onNext(%s)", this.value);
            }
            case ON_ERROR: {
                return String.format("onError(%s)", this.throwable);
            }
            case ON_COMPLETE: {
                return "onComplete()";
            }
        }
        return String.format("Signal type=%s", new Object[]{this.type});
    }
}

