/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.QueueSupplier;

public final class UnicastProcessor<T>
extends FluxProcessor<T, T>
implements Fuseable.QueueSubscription<T>,
Fuseable,
Producer,
Receiver {
    final Queue<T> queue;
    final Consumer<? super T> onOverflow;
    volatile Cancellation onTerminate;
    static final AtomicReferenceFieldUpdater<UnicastProcessor, Cancellation> ON_TERMINATE = AtomicReferenceFieldUpdater.newUpdater(UnicastProcessor.class, Cancellation.class, "onTerminate");
    volatile boolean done;
    Throwable error;
    volatile Subscriber<? super T> actual;
    volatile boolean cancelled;
    volatile int once;
    static final AtomicIntegerFieldUpdater<UnicastProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnicastProcessor.class, "once");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<UnicastProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(UnicastProcessor.class, "wip");
    volatile long requested;
    static final AtomicLongFieldUpdater<UnicastProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnicastProcessor.class, "requested");
    volatile boolean enableOperatorFusion;

    public static <T> UnicastProcessor<T> create() {
        return UnicastProcessor.create(QueueSupplier.unbounded().get());
    }

    public static <T> UnicastProcessor<T> create(Queue<T> queue) {
        return new UnicastProcessor<T>(queue);
    }

    public static <T> UnicastProcessor<T> create(Queue<T> queue, Cancellation endcallback) {
        return new UnicastProcessor<T>(queue, endcallback);
    }

    public static <T> UnicastProcessor<T> create(Queue<T> queue, Consumer<? super T> onOverflow, Cancellation endcallback) {
        return new UnicastProcessor<T>(queue, onOverflow, endcallback);
    }

    public UnicastProcessor(Queue<T> queue) {
        this.queue = Objects.requireNonNull(queue, "queue");
        this.onTerminate = null;
        this.onOverflow = null;
    }

    public UnicastProcessor(Queue<T> queue, Cancellation onTerminate) {
        this.queue = Objects.requireNonNull(queue, "queue");
        this.onTerminate = Objects.requireNonNull(onTerminate, "onTerminate");
        this.onOverflow = null;
    }

    public UnicastProcessor(Queue<T> queue, Consumer<? super T> onOverflow, Cancellation onTerminate) {
        this.queue = Objects.requireNonNull(queue, "queue");
        this.onOverflow = Objects.requireNonNull(onOverflow, "onOverflow");
        this.onTerminate = Objects.requireNonNull(onTerminate, "onTerminate");
    }

    void doTerminate() {
        Cancellation r = this.onTerminate;
        if (r != null && ON_TERMINATE.compareAndSet(this, r, null)) {
            r.dispose();
        }
    }

    void drainRegular(Subscriber<? super T> a) {
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            long e;
            long r = this.requested;
            for (e = 0L; r != e; ++e) {
                boolean empty;
                boolean d = this.done;
                T t = q.poll();
                boolean bl = empty = t == null;
                if (this.checkTerminated(d, empty, a, q)) {
                    return;
                }
                if (empty) break;
                a.onNext(t);
            }
            if (r == e && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                return;
            }
            if (e == 0L || r == Long.MAX_VALUE) continue;
            REQUESTED.addAndGet(this, -e);
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    void drainFused(Subscriber<? super T> a) {
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            if (this.cancelled) {
                q.clear();
                this.actual = null;
                return;
            }
            boolean d = this.done;
            a.onNext(null);
            if (!d) continue;
            this.actual = null;
            Throwable ex = this.error;
            if (ex != null) {
                a.onError(ex);
            } else {
                a.onComplete();
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        do {
            Subscriber<? super T> a;
            if ((a = this.actual) == null) continue;
            if (this.enableOperatorFusion) {
                this.drainFused(a);
            } else {
                this.drainRegular(a);
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a, Queue<T> q) {
        if (this.cancelled) {
            q.clear();
            this.actual = null;
            return true;
        }
        if (d && empty) {
            Throwable e = this.error;
            this.actual = null;
            if (e != null) {
                a.onError(e);
            } else {
                a.onComplete();
            }
            return true;
        }
        return false;
    }

    public void onSubscribe(Subscription s) {
        if (this.done || this.cancelled) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    public void onNext(T t) {
        if (this.done || this.cancelled) {
            return;
        }
        if (!this.queue.offer(t)) {
            IllegalStateException ex = Exceptions.failWithOverflow();
            if (this.onOverflow != null) {
                try {
                    this.onOverflow.accept(t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    ex.initCause(e);
                }
            }
            this.onError(Operators.onOperatorError(null, ex, t));
            return;
        }
        this.drain();
    }

    public void onError(Throwable t) {
        if (this.done || this.cancelled) {
            Operators.onErrorDropped(t);
            return;
        }
        this.error = t;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            s.onSubscribe((Subscription)this);
            this.actual = s;
            if (this.cancelled) {
                this.actual = null;
            } else {
                this.drain();
            }
        } else {
            Operators.error(s, new IllegalStateException("This processor allows only a single Subscriber"));
        }
    }

    public void request(long n) {
        if (Operators.validate(n)) {
            Operators.getAndAddCap(REQUESTED, this, n);
            this.drain();
        }
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.doTerminate();
        if (!this.enableOperatorFusion && WIP.getAndIncrement(this) == 0) {
            this.queue.clear();
        }
    }

    @Override
    public T poll() {
        return this.queue.poll();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public int requestFusion(int requestedMode) {
        if ((requestedMode & 2) != 0) {
            this.enableOperatorFusion = true;
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isStarted() {
        return this.once == 1 && !this.done && !this.cancelled;
    }

    @Override
    public boolean isTerminated() {
        return this.done;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public Object downstream() {
        return this.actual;
    }

    @Override
    public Object upstream() {
        return this.onTerminate;
    }

    @Override
    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public long requestedFromDownstream() {
        return this.requested;
    }
}

