/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.EventLoopProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.TopicProcessor;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.concurrent.WaitStrategy;

public final class WorkQueueProcessor<E>
extends EventLoopProcessor<E> {
    private static final Supplier FACTORY = EventLoopProcessor.Slot::new;
    final RingBuffer.Sequence workSequence = RingBuffer.newSequence(-1L);
    final RingBuffer.Sequence retrySequence = RingBuffer.newSequence(-1L);
    volatile RingBuffer<EventLoopProcessor.Slot<E>> retryBuffer;
    static final AtomicReferenceFieldUpdater<WorkQueueProcessor, RingBuffer> RETRY_REF = AtomicReferenceFieldUpdater.newUpdater(WorkQueueProcessor.class, RingBuffer.class, "retryBuffer");
    final WaitStrategy writeWait;
    volatile int replaying;
    static final AtomicIntegerFieldUpdater<WorkQueueProcessor> REPLAYING = AtomicIntegerFieldUpdater.newUpdater(WorkQueueProcessor.class, "replaying");

    public static <E> WorkQueueProcessor<E> create() {
        return WorkQueueProcessor.create(WorkQueueProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(boolean autoCancel) {
        return WorkQueueProcessor.create(WorkQueueProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service) {
        return WorkQueueProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service, boolean autoCancel) {
        return WorkQueueProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(String name) {
        return WorkQueueProcessor.create(name, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize) {
        return WorkQueueProcessor.create(name, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.create(name, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service, int bufferSize) {
        return WorkQueueProcessor.create(service, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.create(service, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.create(name, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, false, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService executor, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.create(executor, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService executor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(null, executor, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, false, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(boolean autoCancel) {
        return WorkQueueProcessor.share(WorkQueueProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service) {
        return WorkQueueProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service, boolean autoCancel) {
        return WorkQueueProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize) {
        return WorkQueueProcessor.share(name, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.share(name, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service, int bufferSize) {
        return WorkQueueProcessor.share(service, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.share(service, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.share(name, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, true, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService executor, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.share(executor, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService executor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(null, executor, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, true, autoCancel);
    }

    WorkQueueProcessor(String name, int bufferSize, WaitStrategy waitStrategy, boolean share, boolean autoCancel) {
        this(new EventLoopProcessor.EventLoopFactory(name, autoCancel), null, bufferSize, waitStrategy, share, autoCancel);
    }

    WorkQueueProcessor(ThreadFactory threadFactory, ExecutorService executor, int bufferSize, WaitStrategy waitStrategy, boolean share, boolean autoCancel) {
        super(bufferSize, threadFactory, executor, autoCancel, share, FACTORY, waitStrategy);
        this.writeWait = waitStrategy;
        this.ringBuffer.addGatingSequence(this.workSequence);
    }

    @Override
    public void subscribe(Subscriber<? super E> subscriber) {
        super.subscribe(subscriber);
        if (!this.alive()) {
            TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.workSequence).subscribe(subscriber);
            return;
        }
        QueueSubscriberLoop<? super E> signalProcessor = new QueueSubscriberLoop<E>(subscriber, this);
        try {
            this.incrementSubscribers();
            ((QueueSubscriberLoop)signalProcessor).sequence.set(this.workSequence.getAsLong());
            this.ringBuffer.addGatingSequence(((QueueSubscriberLoop)signalProcessor).sequence);
            this.executor.execute(signalProcessor);
        }
        catch (Throwable t) {
            this.decrementSubscribers();
            this.ringBuffer.removeGatingSequence(((QueueSubscriberLoop)signalProcessor).sequence);
            if (RejectedExecutionException.class.isAssignableFrom(t.getClass())) {
                TopicProcessor.coldSource(this.ringBuffer, t, this.error, this.workSequence).subscribe(subscriber);
            }
            Operators.error(subscriber, t);
        }
    }

    @Override
    public Flux<E> drain() {
        return TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.workSequence);
    }

    @Override
    protected void doError(Throwable t) {
        this.writeWait.signalAllWhenBlocking();
    }

    @Override
    protected void doComplete() {
        this.writeWait.signalAllWhenBlocking();
    }

    @Override
    protected void requestTask(Subscription s) {
        new Thread(EventLoopProcessor.createRequestTask(s, () -> {
            if (!this.alive()) {
                if (this.cancelled) {
                    throw Exceptions.failWithCancel();
                }
                WaitStrategy.throwAlert();
            }
        }, null, this.ringBuffer::getMinimumGatingSequence, this.readWait, this, this.ringBuffer.bufferSize()), this.name + "[request-task]").start();
    }

    @Override
    public long getPending() {
        return this.ringBuffer.remainingCapacity() + (this.retryBuffer != null ? this.retryBuffer.remainingCapacity() : 0L);
    }

    RingBuffer<EventLoopProcessor.Slot<E>> retryBuffer() {
        RingBuffer<EventLoopProcessor.Slot<E>> retry = this.retryBuffer;
        if (retry == null) {
            retry = RingBuffer.createMultiProducer(FACTORY, 32, WaitStrategy.busySpin());
            retry.addGatingSequence(this.retrySequence);
            if (!RETRY_REF.compareAndSet(this, null, retry)) {
                retry = this.retryBuffer;
            }
        }
        return retry;
    }

    @Override
    public long downstreamCount() {
        return this.ringBuffer.getSequenceReceivers().length - 1;
    }

    @Override
    public void run() {
        if (!this.alive()) {
            WaitStrategy.throwAlert();
        }
    }

    static final class QueueSubscriberLoop<T>
    implements Runnable,
    Producer,
    Trackable,
    Subscription,
    Receiver {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final RingBuffer.Sequence sequence = EventLoopProcessor.wrap(-1L, (Object)this);
        private final RingBuffer.Sequence pendingRequest = RingBuffer.newSequence(0L);
        private final RingBuffer.Reader barrier;
        private final WorkQueueProcessor<T> processor;
        private final Subscriber<? super T> subscriber;
        private final Runnable waiter = new Runnable(){

            @Override
            public void run() {
                if (barrier.isAlerted() || !this.isRunning() || this.replay(pendingRequest.getAsLong() == Long.MAX_VALUE)) {
                    WaitStrategy.throwAlert();
                }
            }
        };

        public QueueSubscriberLoop(Subscriber<? super T> subscriber, WorkQueueProcessor<T> processor) {
            this.processor = processor;
            this.subscriber = subscriber;
            this.barrier = processor.ringBuffer.newReader();
        }

        public RingBuffer.Sequence getSequence() {
            return this.sequence;
        }

        public void halt() {
            this.running.set(false);
            this.barrier.alert();
        }

        public boolean isRunning() {
            return this.running.get() && (this.processor.terminated == 0 || this.processor.error == null && this.processor.ringBuffer.getAsLong() > this.sequence.getAsLong());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean unbounded;
                if (!this.running.compareAndSet(false, true)) {
                    Operators.error(this.subscriber, new IllegalStateException("Thread is already running"));
                    return;
                }
                if (!this.processor.startSubscriber(this.subscriber, this)) {
                    return;
                }
                boolean processedSequence = true;
                long cachedAvailableSequence = Long.MIN_VALUE;
                long nextSequence = this.sequence.getAsLong();
                EventLoopProcessor.Slot event = null;
                if (!EventLoopProcessor.waitRequestOrTerminalEvent(this.pendingRequest, this.barrier, this.running, this.sequence, this.waiter)) {
                    if (!this.running.get()) {
                        return;
                    }
                    if (this.processor.terminated == 1 && this.processor.ringBuffer.getAsLong() == -1L) {
                        if (this.processor.error != null) {
                            this.subscriber.onError(this.processor.error);
                            return;
                        }
                        this.subscriber.onComplete();
                        return;
                    }
                }
                boolean bl = unbounded = this.pendingRequest.getAsLong() == Long.MAX_VALUE;
                if (this.replay(unbounded)) {
                    this.running.set(false);
                    return;
                }
                while (true) {
                    try {
                        while (true) {
                            if (processedSequence) {
                                processedSequence = false;
                                do {
                                    nextSequence = this.processor.workSequence.getAsLong() + 1L;
                                    while (!unbounded && this.pendingRequest.getAsLong() == 0L) {
                                        if (!this.isRunning()) {
                                            WaitStrategy.throwAlert();
                                        }
                                        LockSupport.parkNanos(1L);
                                    }
                                    this.sequence.set(nextSequence - 1L);
                                } while (!this.processor.workSequence.compareAndSet(nextSequence - 1L, nextSequence));
                            }
                            if (cachedAvailableSequence < nextSequence) break;
                            event = (EventLoopProcessor.Slot)this.processor.ringBuffer.get(nextSequence);
                            try {
                                this.readNextEvent(unbounded);
                            }
                            catch (Exception ce) {
                                if (!WaitStrategy.isAlert(ce)) {
                                    throw ce;
                                }
                                this.barrier.clearAlert();
                                throw Exceptions.failWithCancel();
                            }
                            this.subscriber.onNext(event.value);
                            processedSequence = true;
                        }
                        this.processor.readWait.signalAllWhenBlocking();
                        try {
                            cachedAvailableSequence = this.barrier.waitFor(nextSequence, this.waiter);
                            continue;
                        }
                        catch (Exception ce) {
                            if (!WaitStrategy.isAlert(ce)) {
                                throw ce;
                            }
                            this.barrier.clearAlert();
                            if (this.running.get()) {
                                throw ce;
                            }
                            this.processor.decrementSubscribers();
                            try {
                                while (true) {
                                    try {
                                        cachedAvailableSequence = this.barrier.waitFor(nextSequence);
                                        event = (EventLoopProcessor.Slot)this.processor.ringBuffer.get(nextSequence);
                                    }
                                    catch (Exception cee) {
                                        if (!WaitStrategy.isAlert(cee)) {
                                            throw ce;
                                        }
                                        this.barrier.clearAlert();
                                        continue;
                                    }
                                    break;
                                }
                                this.reschedule(event);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.processor.incrementSubscribers();
                            throw ce;
                        }
                    }
                    catch (RuntimeException ce) {
                        if (Exceptions.isCancel(ce)) {
                            this.reschedule(event);
                        } else {
                            if (!WaitStrategy.isAlert(ce)) {
                                throw ce;
                            }
                            this.barrier.clearAlert();
                            if (!this.running.get()) {
                            } else {
                                if (this.processor.terminated != 1) continue;
                                if (this.processor.error != null) {
                                    this.subscriber.onError(this.processor.error);
                                } else {
                                    if (this.processor.ringBuffer.getPending() != 0) continue;
                                    this.subscriber.onComplete();
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        this.reschedule(event);
                        this.subscriber.onError(ex);
                        this.sequence.set(nextSequence);
                        processedSequence = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.processor.decrementSubscribers();
                this.processor.ringBuffer.removeGatingSequence(this.sequence);
                this.running.set(false);
                this.processor.writeWait.signalAllWhenBlocking();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean replay(boolean unbounded) {
            if (REPLAYING.compareAndSet(this.processor, 0, 1)) {
                try {
                    RingBuffer q = this.processor.retryBuffer;
                    if (q == null) {
                        boolean bl = false;
                        return bl;
                    }
                    while (true) {
                        if (!this.running.get()) {
                            boolean bl = true;
                            return bl;
                        }
                        long cursor = this.processor.retrySequence.getAsLong() + 1L;
                        if (q.getCursor() < cursor) break;
                        EventLoopProcessor.Slot signal = q.get(cursor);
                        if (signal.value == null) continue;
                        this.readNextEvent(unbounded);
                        this.subscriber.onNext(signal.value);
                        this.processor.retrySequence.set(cursor);
                        continue;
                        break;
                    }
                }
                catch (RuntimeException ce) {
                    if (!Exceptions.isCancel(ce)) throw ce;
                    this.running.set(false);
                    boolean bl = true;
                    return bl;
                }
                this.processor.readWait.signalAllWhenBlocking();
                if (this.processor.alive()) return false;
                return true;
                finally {
                    REPLAYING.compareAndSet(this.processor, 1, 0);
                }
            }
            if (this.processor.alive()) return false;
            return true;
        }

        private void reschedule(EventLoopProcessor.Slot<T> event) {
            if (event != null && event.value != null) {
                RingBuffer<EventLoopProcessor.Slot<T>> retry = this.processor.retryBuffer();
                long seq = retry.next();
                retry.get((long)seq).value = event.value;
                retry.publish(seq);
                this.barrier.alert();
                this.processor.readWait.signalAllWhenBlocking();
            }
        }

        private void readNextEvent(boolean unbounded) {
            while (!unbounded && EventLoopProcessor.getAndSub(this.pendingRequest, 1L) == 0L) {
                if (!this.isRunning()) {
                    WaitStrategy.throwAlert();
                }
                LockSupport.parkNanos(1L);
            }
        }

        @Override
        public long requestedFromDownstream() {
            return this.pendingRequest.getAsLong();
        }

        @Override
        public boolean isCancelled() {
            return !this.running.get();
        }

        @Override
        public boolean isStarted() {
            return this.sequence.getAsLong() != -1L;
        }

        @Override
        public boolean isTerminated() {
            return !this.running.get();
        }

        @Override
        public long getPending() {
            return this.processor.ringBuffer.getPending();
        }

        @Override
        public long getCapacity() {
            return this.processor.getCapacity();
        }

        @Override
        public Object downstream() {
            return this.subscriber;
        }

        @Override
        public Object upstream() {
            return this.processor;
        }

        public void request(long n) {
            if (Operators.checkRequest(n, this.subscriber)) {
                if (!this.running.get()) {
                    return;
                }
                EventLoopProcessor.addCap(this.pendingRequest, n);
            }
        }

        public void cancel() {
            this.halt();
        }
    }
}

