/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.Cancellation;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class ExecutorScheduler
implements Scheduler {
    final Executor executor;
    final boolean trampoline;

    public ExecutorScheduler(Executor executor, boolean trampoline) {
        this.executor = executor;
        this.trampoline = trampoline;
    }

    @Override
    public Cancellation schedule(Runnable task) {
        Objects.requireNonNull(task, "task");
        ExecutorPlainRunnable r = new ExecutorPlainRunnable(task);
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
        return r;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return this.trampoline ? new ExecutorSchedulerTrampolineWorker(this.executor) : new ExecutorSchedulerWorker(this.executor);
    }

    static final class ExecutorSchedulerTrampolineWorker
    implements Scheduler.Worker,
    WorkerDelete,
    Runnable {
        final Executor executor;
        final Queue<ExecutorTrackedRunnable> queue;
        volatile boolean terminated;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ExecutorSchedulerTrampolineWorker> WIP = AtomicIntegerFieldUpdater.newUpdater(ExecutorSchedulerTrampolineWorker.class, "wip");

        public ExecutorSchedulerTrampolineWorker(Executor executor) {
            this.executor = executor;
            this.queue = new ConcurrentLinkedQueue<ExecutorTrackedRunnable>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cancellation schedule(Runnable task) {
            Objects.requireNonNull(task, "task");
            if (this.terminated) {
                return Scheduler.REJECTED;
            }
            ExecutorTrackedRunnable r = new ExecutorTrackedRunnable(task, this, false);
            ExecutorSchedulerTrampolineWorker executorSchedulerTrampolineWorker = this;
            synchronized (executorSchedulerTrampolineWorker) {
                if (this.terminated) {
                    return Scheduler.REJECTED;
                }
                this.queue.offer(r);
            }
            if (WIP.getAndIncrement(this) == 0) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException ex) {
                    r.dispose();
                    return Scheduler.REJECTED;
                }
            }
            return r;
        }

        @Override
        public void shutdown() {
            ExecutorTrackedRunnable r;
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            Queue<ExecutorTrackedRunnable> q = this.queue;
            while ((r = q.poll()) != null && !q.isEmpty()) {
                r.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(ExecutorTrackedRunnable r) {
            ExecutorSchedulerTrampolineWorker executorSchedulerTrampolineWorker = this;
            synchronized (executorSchedulerTrampolineWorker) {
                if (!this.terminated) {
                    this.queue.remove(r);
                }
            }
        }

        @Override
        public void run() {
            int e;
            Queue<ExecutorTrackedRunnable> q = this.queue;
            do {
                int r = this.wip;
                for (e = 0; e != r; ++e) {
                    if (this.terminated) {
                        return;
                    }
                    ExecutorTrackedRunnable task = q.poll();
                    if (task == null) break;
                    task.run();
                }
                if (e != r || !this.terminated) continue;
                return;
            } while (WIP.addAndGet(this, -e) != 0);
        }
    }

    static final class ExecutorSchedulerWorker
    implements Scheduler.Worker,
    WorkerDelete {
        final Executor executor;
        volatile boolean terminated;
        OpenHashSet<ExecutorTrackedRunnable> tasks;

        public ExecutorSchedulerWorker(Executor executor) {
            this.executor = executor;
            this.tasks = new OpenHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cancellation schedule(Runnable task) {
            Objects.requireNonNull(task, "task");
            if (this.terminated) {
                return Scheduler.REJECTED;
            }
            ExecutorTrackedRunnable r = new ExecutorTrackedRunnable(task, this, true);
            ExecutorSchedulerWorker executorSchedulerWorker = this;
            synchronized (executorSchedulerWorker) {
                if (this.terminated) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(r);
            }
            try {
                this.executor.execute(r);
            }
            catch (RejectedExecutionException ex) {
                ExecutorSchedulerWorker executorSchedulerWorker2 = this;
                synchronized (executorSchedulerWorker2) {
                    if (!this.terminated) {
                        this.tasks.remove(r);
                    }
                }
                return Scheduler.REJECTED;
            }
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            OpenHashSet<ExecutorTrackedRunnable> list;
            if (this.terminated) {
                return;
            }
            ExecutorSchedulerWorker executorSchedulerWorker = this;
            synchronized (executorSchedulerWorker) {
                if (this.terminated) {
                    return;
                }
                this.terminated = true;
                list = this.tasks;
                this.tasks = null;
            }
            if (!list.isEmpty()) {
                Object[] a;
                for (Object o : a = list.keys()) {
                    if (o == null) continue;
                    ((ExecutorTrackedRunnable)o).dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(ExecutorTrackedRunnable r) {
            ExecutorSchedulerWorker executorSchedulerWorker = this;
            synchronized (executorSchedulerWorker) {
                if (!this.terminated) {
                    this.tasks.remove(r);
                }
            }
        }
    }

    static final class ExecutorTrackedRunnable
    extends AtomicBoolean
    implements Runnable,
    Cancellation {
        private static final long serialVersionUID = 3503344795919906192L;
        final Runnable task;
        final WorkerDelete parent;
        final boolean callRemoveOnFinish;

        public ExecutorTrackedRunnable(Runnable task, WorkerDelete parent, boolean callRemoveOnFinish) {
            this.task = task;
            this.parent = parent;
            this.callRemoveOnFinish = callRemoveOnFinish;
        }

        @Override
        public void run() {
            try {
                if (!this.get()) {
                    this.task.run();
                }
            }
            catch (Throwable ex) {
                Schedulers.handleError(ex);
            }
            finally {
                if (this.callRemoveOnFinish) {
                    this.dispose();
                }
            }
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.delete(this);
            }
        }

        @Override
        public String toString() {
            return "ExecutorTrackedRunnable[cancelled=" + this.get() + ", task=" + this.task + "]";
        }
    }

    static interface WorkerDelete {
        public void delete(ExecutorTrackedRunnable var1);
    }

    static final class ExecutorPlainRunnable
    extends AtomicBoolean
    implements Runnable,
    Cancellation {
        private static final long serialVersionUID = 5116223460201378097L;
        final Runnable task;

        public ExecutorPlainRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (!this.get()) {
                    this.task.run();
                }
            }
            catch (Throwable ex) {
                Schedulers.handleError(ex);
            }
        }

        @Override
        public void dispose() {
            this.set(true);
        }

        @Override
        public String toString() {
            return "ExecutorPlainRunnable[cancelled=" + this.get() + ", task=" + this.task + "]";
        }
    }
}

