/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Cancellation;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class ExecutorServiceScheduler
implements Scheduler {
    static final Runnable EMPTY = () -> {};
    static final Future<?> CANCELLED_FUTURE = new FutureTask<Object>(EMPTY, null);
    static final Future<?> FINISHED = new FutureTask<Object>(EMPTY, null);
    final ExecutorService executor;
    final boolean interruptOnCancel;

    public ExecutorServiceScheduler(ExecutorService executor, boolean interruptOnCancel) {
        this.executor = executor;
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorServiceWorker(this.executor, this.interruptOnCancel);
    }

    @Override
    public Cancellation schedule(Runnable task) {
        Future<?> f = this.executor.submit(task);
        return () -> f.cancel(this.interruptOnCancel);
    }

    @Override
    public void shutdown() {
        if (this.interruptOnCancel) {
            this.executor.submit(EMPTY).cancel(true);
        }
        this.executor.shutdown();
    }

    static final class ScheduledRunnable
    extends AtomicReference<Future<?>>
    implements Runnable,
    Cancellation {
        private static final long serialVersionUID = 2284024836904862408L;
        final Runnable task;
        final ExecutorServiceWorker parent;
        volatile Thread current;
        static final AtomicReferenceFieldUpdater<ScheduledRunnable, Thread> CURRENT = AtomicReferenceFieldUpdater.newUpdater(ScheduledRunnable.class, Thread.class, "current");

        public ScheduledRunnable(Runnable task, ExecutorServiceWorker parent) {
            this.task = task;
            this.parent = parent;
        }

        @Override
        public void run() {
            CURRENT.lazySet(this, Thread.currentThread());
            try {
                try {
                    this.task.run();
                }
                catch (Throwable e) {
                    Schedulers.handleError(e);
                }
            }
            finally {
                Future a;
                while ((a = (Future)this.get()) != CANCELLED_FUTURE) {
                    if (!this.compareAndSet(a, FINISHED)) continue;
                    this.parent.delete(this);
                    break;
                }
                CURRENT.lazySet(this, null);
            }
        }

        void doCancel(Future<?> a) {
            a.cancel(this.parent.interruptOnCancel);
        }

        void cancelFuture() {
            Future a;
            do {
                if ((a = (Future)this.get()) != FINISHED) continue;
                return;
            } while (!this.compareAndSet(a, CANCELLED_FUTURE));
            if (a != null) {
                this.doCancel(a);
            }
        }

        @Override
        public void dispose() {
            Future a;
            do {
                if ((a = (Future)this.get()) != FINISHED) continue;
                return;
            } while (!this.compareAndSet(a, CANCELLED_FUTURE));
            if (a != null) {
                this.doCancel(a);
            }
            this.parent.delete(this);
        }

        void setFuture(Future<?> f) {
            do {
                Future a;
                if ((a = (Future)this.get()) == FINISHED) {
                    return;
                }
                if (a != CANCELLED_FUTURE) continue;
                this.doCancel(a);
                return;
            } while (!this.compareAndSet(null, f));
        }

        @Override
        public String toString() {
            return "ScheduledRunnable[cancelled=" + this.get() + ", task=" + this.task + "]";
        }
    }

    static final class ExecutorServiceWorker
    implements Scheduler.Worker {
        final ExecutorService executor;
        final boolean interruptOnCancel;
        volatile boolean terminated;
        OpenHashSet<ScheduledRunnable> tasks;

        public ExecutorServiceWorker(ExecutorService executor, boolean interruptOnCancel) {
            this.executor = executor;
            this.interruptOnCancel = interruptOnCancel;
            this.tasks = new OpenHashSet();
        }

        @Override
        public Cancellation schedule(Runnable t) {
            ScheduledRunnable sr = new ScheduledRunnable(t, this);
            if (this.add(sr)) {
                Future<?> f = this.executor.submit(sr);
                sr.setFuture(f);
            }
            return sr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(ScheduledRunnable sr) {
            if (!this.terminated) {
                ExecutorServiceWorker executorServiceWorker = this;
                synchronized (executorServiceWorker) {
                    if (!this.terminated) {
                        this.tasks.add(sr);
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delete(ScheduledRunnable sr) {
            if (!this.terminated) {
                ExecutorServiceWorker executorServiceWorker = this;
                synchronized (executorServiceWorker) {
                    if (!this.terminated) {
                        this.tasks.remove(sr);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            if (!this.terminated) {
                OpenHashSet<ScheduledRunnable> coll;
                ExecutorServiceWorker executorServiceWorker = this;
                synchronized (executorServiceWorker) {
                    if (this.terminated) {
                        return;
                    }
                    coll = this.tasks;
                    this.tasks = null;
                    this.terminated = true;
                }
                if (!coll.isEmpty()) {
                    Object[] a;
                    for (Object o : a = coll.keys()) {
                        if (o == null) continue;
                        ((ScheduledRunnable)o).cancelFuture();
                    }
                }
            }
        }
    }
}

