/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import reactor.core.Cancellation;
import reactor.core.scheduler.Scheduler;

final class ImmediateScheduler
implements Scheduler {
    private static final ImmediateScheduler INSTANCE = new ImmediateScheduler();
    static final Cancellation EMPTY = () -> {};

    public static Scheduler instance() {
        return INSTANCE;
    }

    private ImmediateScheduler() {
    }

    @Override
    public Cancellation schedule(Runnable task) {
        task.run();
        return EMPTY;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ImmediateSchedulerWorker();
    }

    static final class ImmediateSchedulerWorker
    implements Scheduler.Worker {
        volatile boolean shutdown;

        ImmediateSchedulerWorker() {
        }

        @Override
        public Cancellation schedule(Runnable task) {
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            task.run();
            return EMPTY;
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
        }
    }
}

