/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Cancellation;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class ParallelScheduler
implements Scheduler {
    static final AtomicLong COUNTER = new AtomicLong();
    final int n;
    final ThreadFactory factory;
    volatile ExecutorService[] executors;
    static final AtomicReferenceFieldUpdater<ParallelScheduler, ExecutorService[]> EXECUTORS = AtomicReferenceFieldUpdater.newUpdater(ParallelScheduler.class, ExecutorService[].class, "executors");
    static final ExecutorService[] SHUTDOWN = new ExecutorService[0];
    static final ExecutorService TERMINATED = Executors.newSingleThreadExecutor();
    int roundRobin;

    ParallelScheduler(int n, ThreadFactory factory) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > 0 required but it was " + n);
        }
        this.n = n;
        this.factory = factory;
        this.init(n);
    }

    void init(int n) {
        ExecutorService[] a = new ExecutorService[n];
        for (int i = 0; i < n; ++i) {
            a[i] = Executors.newSingleThreadExecutor(this.factory);
        }
        EXECUTORS.lazySet(this, a);
    }

    @Override
    public void start() {
        ExecutorService[] a;
        ExecutorService[] b = null;
        do {
            if ((a = this.executors) != SHUTDOWN) {
                if (b != null) {
                    for (ExecutorService exec : b) {
                        exec.shutdownNow();
                    }
                }
                return;
            }
            if (b != null) continue;
            b = new ExecutorService[this.n];
            for (int i = 0; i < this.n; ++i) {
                b[i] = Executors.newSingleThreadExecutor(this.factory);
            }
        } while (!EXECUTORS.compareAndSet(this, a, b));
    }

    @Override
    public void shutdown() {
        ExecutorService[] a = this.executors;
        if (a != SHUTDOWN && (a = EXECUTORS.getAndSet(this, SHUTDOWN)) != SHUTDOWN) {
            for (ExecutorService exec : a) {
                exec.shutdownNow();
            }
        }
    }

    ExecutorService pick() {
        ExecutorService[] a = this.executors;
        if (a != SHUTDOWN) {
            int idx = this.roundRobin;
            if (idx == this.n) {
                idx = 0;
                this.roundRobin = 0;
            } else {
                this.roundRobin = idx + 1;
            }
            return a[idx];
        }
        return TERMINATED;
    }

    @Override
    public Cancellation schedule(Runnable task) {
        ExecutorService exec = this.pick();
        Future<?> f = exec.submit(task);
        return () -> f.cancel(this.executors == SHUTDOWN);
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ParallelWorker(this.pick());
    }

    static {
        TERMINATED.shutdownNow();
    }

    static final class ParallelWorker
    implements Scheduler.Worker {
        final ExecutorService exec;
        OpenHashSet<ParallelWorkerTask> tasks;
        volatile boolean shutdown;

        public ParallelWorker(ExecutorService exec) {
            this.exec = exec;
            this.tasks = new OpenHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cancellation schedule(Runnable task) {
            Future<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            ParallelWorkerTask pw = new ParallelWorkerTask(task, this);
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(pw);
            }
            try {
                f = this.exec.submit(pw);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            if (this.shutdown) {
                f.cancel(true);
                return Scheduler.REJECTED;
            }
            pw.setFuture(f);
            return pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            OpenHashSet<ParallelWorkerTask> set;
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                set = this.tasks;
                this.tasks = null;
            }
            if (set != null) {
                Object[] a;
                for (Object o : a = set.keys()) {
                    if (o == null) continue;
                    ((ParallelWorkerTask)o).cancelFuture();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(ParallelWorkerTask task) {
            if (this.shutdown) {
                return;
            }
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                if (this.shutdown) {
                    return;
                }
                this.tasks.remove(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int pendingTasks() {
            if (this.shutdown) {
                return 0;
            }
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                OpenHashSet<ParallelWorkerTask> set = this.tasks;
                if (set != null) {
                    return set.size();
                }
                return 0;
            }
        }

        static final class ParallelWorkerTask
        implements Runnable,
        Cancellation {
            final Runnable run;
            final ParallelWorker parent;
            volatile boolean cancelled;
            volatile Future<?> future;
            static final AtomicReferenceFieldUpdater<ParallelWorkerTask, Future> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ParallelWorkerTask.class, Future.class, "future");
            static final Future<Object> FINISHED = CompletableFuture.completedFuture(null);
            static final Future<Object> CANCELLED = CompletableFuture.completedFuture(null);

            public ParallelWorkerTask(Runnable run, ParallelWorker parent) {
                this.run = run;
                this.parent = parent;
            }

            @Override
            public void run() {
                if (this.cancelled || this.parent.shutdown) {
                    return;
                }
                try {
                    try {
                        this.run.run();
                    }
                    catch (Throwable ex) {
                        Schedulers.handleError(ex);
                    }
                }
                finally {
                    Future<?> f;
                    while ((f = this.future) != CANCELLED) {
                        if (!FUTURE.compareAndSet(this, f, FINISHED)) continue;
                        this.parent.remove(this);
                        break;
                    }
                }
            }

            @Override
            public void dispose() {
                if (!this.cancelled) {
                    this.cancelled = true;
                    Future<Object> f = this.future;
                    if (f != CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != CANCELLED && f != FINISHED) {
                        if (f != null) {
                            f.cancel(this.parent.shutdown);
                        }
                        this.parent.remove(this);
                    }
                }
            }

            void setFuture(Future<?> f) {
                if (!(this.future == null && FUTURE.compareAndSet(this, null, f) || this.future == FINISHED)) {
                    f.cancel(this.parent.shutdown);
                }
            }

            void cancelFuture() {
                Future<Object> f = this.future;
                if (f != CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != null && f != CANCELLED && f != FINISHED) {
                    f.cancel(true);
                }
            }
        }
    }
}

