/*
 * Decompiled with CFR 0.152.
 */
package reactor.util.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.util.concurrent.SpscArrayQueue;
import reactor.util.concurrent.SpscLinkedArrayQueue;

public final class QueueSupplier<T>
implements Supplier<Queue<T>> {
    public static final int XS_BUFFER_SIZE = Math.max(8, Integer.parseInt(System.getProperty("reactor.bufferSize.x", "32")));
    public static final int SMALL_BUFFER_SIZE = Math.max(16, Integer.parseInt(System.getProperty("reactor.bufferSize.small", "256")));
    final long batchSize;
    static final Supplier ONE_SUPPLIER = OneQueue::new;
    static final Supplier XS_SUPPLIER = () -> new SpscArrayQueue(XS_BUFFER_SIZE);
    static final Supplier SMALL_SUPPLIER = () -> new SpscArrayQueue(SMALL_BUFFER_SIZE);
    static final Supplier SMALL_UNBOUNDED = () -> new SpscLinkedArrayQueue(SMALL_BUFFER_SIZE);
    static final Supplier XS_UNBOUNDED = () -> new SpscLinkedArrayQueue(XS_BUFFER_SIZE);

    public static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static <T> Supplier<Queue<T>> get(int batchSize) {
        if (batchSize == Integer.MAX_VALUE) {
            return SMALL_UNBOUNDED;
        }
        if (batchSize == XS_BUFFER_SIZE) {
            return XS_SUPPLIER;
        }
        if (batchSize == SMALL_BUFFER_SIZE) {
            return SMALL_SUPPLIER;
        }
        if (batchSize == 1) {
            return ONE_SUPPLIER;
        }
        return new QueueSupplier<T>(Math.max(8, batchSize));
    }

    public static boolean isPowerOfTwo(int x) {
        return Integer.bitCount(x) == 1;
    }

    public static <T> Supplier<Queue<T>> one() {
        return ONE_SUPPLIER;
    }

    public static <T> Supplier<Queue<T>> small() {
        return SMALL_SUPPLIER;
    }

    public static <T> Supplier<Queue<T>> unbounded() {
        return SMALL_UNBOUNDED;
    }

    public static <T> Supplier<Queue<T>> unbounded(int linkSize) {
        if (linkSize == XS_BUFFER_SIZE) {
            return XS_UNBOUNDED;
        }
        if (linkSize == SMALL_BUFFER_SIZE) {
            return SMALL_UNBOUNDED;
        }
        return () -> new SpscLinkedArrayQueue(linkSize);
    }

    public static <T> Supplier<Queue<T>> xs() {
        return XS_SUPPLIER;
    }

    QueueSupplier(long batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public Queue<T> get() {
        if (this.batchSize > 10000000L) {
            return new SpscLinkedArrayQueue(SMALL_BUFFER_SIZE);
        }
        if (this.batchSize == 1L) {
            return new OneQueue();
        }
        return new SpscArrayQueue((int)this.batchSize);
    }

    static class QueueIterator<T>
    implements Iterator<T> {
        final Queue<T> queue;

        public QueueIterator(Queue<T> queue) {
            this.queue = queue;
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            return this.queue.poll();
        }

        @Override
        public void remove() {
            this.queue.remove();
        }
    }

    static final class OneQueue<T>
    extends AtomicReference<T>
    implements Queue<T> {
        private static final long serialVersionUID = -6079491923525372331L;

        OneQueue() {
        }

        @Override
        public boolean add(T t) {
            while (!this.offer(t)) {
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return false;
        }

        @Override
        public void clear() {
            this.set(null);
        }

        @Override
        public boolean contains(Object o) {
            return Objects.equals(this.get(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public T element() {
            return (T)this.get();
        }

        @Override
        public boolean isEmpty() {
            return this.get() == null;
        }

        @Override
        public Iterator<T> iterator() {
            return new QueueIterator(this);
        }

        @Override
        public boolean offer(T t) {
            if (this.get() != null) {
                return false;
            }
            this.lazySet(t);
            return true;
        }

        @Override
        public T peek() {
            return (T)this.get();
        }

        @Override
        public T poll() {
            Object v = this.get();
            if (v != null) {
                this.lazySet(null);
            }
            return (T)v;
        }

        @Override
        public T remove() {
            return this.getAndSet(null);
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public int size() {
            return this.get() == null ? 0 : 1;
        }

        @Override
        public Object[] toArray() {
            Object t = this.get();
            if (t == null) {
                return new Object[0];
            }
            return new Object[]{t};
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            if (a.length > 0) {
                a[0] = this.get();
                if (a.length > 1) {
                    a[1] = null;
                }
                return a;
            }
            return this.toArray();
        }
    }
}

