/*
 * Decompiled with CFR 0.152.
 */
package reactor.util.function;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Tuple2<T1, T2>
implements Iterable,
Serializable {
    private static final long serialVersionUID = 4839927936743208499L;
    final T1 t1;
    final T2 t2;

    Tuple2(T1 t1, T2 t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    public T1 getT1() {
        return this.t1;
    }

    public T2 getT2() {
        return this.t2;
    }

    @Nullable
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.t1;
            }
            case 1: {
                return this.t2;
            }
        }
        return null;
    }

    public List<Object> toList() {
        return Arrays.asList(this.toArray());
    }

    public Object[] toArray() {
        return new Object[]{this.t1, this.t2};
    }

    @Nonnull
    public Iterator<?> iterator() {
        return Arrays.asList(this.t1, this.t2).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple2 tuple2 = (Tuple2)o;
        return (this.t1 != null ? this.t1.equals(tuple2.t1) : tuple2.t1 == null) && (this.t2 != null ? this.t2.equals(tuple2.t2) : tuple2.t2 == null);
    }

    public int hashCode() {
        int result = this.t1 != null ? this.t1.hashCode() : 0;
        result = 31 * result + (this.t2 != null ? this.t2.hashCode() : 0);
        return result;
    }

    public int size() {
        return 2;
    }

    public String toString() {
        return (this.t1 != null ? this.t1.toString() + "," : "") + (this.t2 != null ? this.t2.toString() : "");
    }
}

