/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.computers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.AnnotationProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.LocationInformation;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.RequestMappingVariableCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class RequestMappingVariableProposalComputer
extends AnnotationProposalComputer {
    @Override
    protected List<ICompletionProposal> computeCompletionProposals(SourceMethod method, String value, IAnnotation annotation, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        return this.computeCompletionProposalsHelper((IMember)method, value, annotation, javaContext);
    }

    @Override
    protected List<ICompletionProposal> computeCompletionProposals(SourceType type, String value, IAnnotation annotation, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        return this.computeCompletionProposalsHelper((IMember)type, value, annotation, javaContext);
    }

    private List<ICompletionProposal> computeCompletionProposalsHelper(IMember element, String value, IAnnotation a, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ITextViewer viewer = javaContext.getViewer();
        if (viewer instanceof SourceViewer) {
            SingleMemberAnnotation singleMemberAnnotation;
            Expression expression;
            int invocationOffset;
            SourceViewer sourceViewer;
            ICompilationUnit cu = javaContext.getCompilationUnit();
            AssistContext assistContext = new AssistContext(cu, (ISourceViewer)(sourceViewer = (SourceViewer)javaContext.getViewer()), invocationOffset = javaContext.getInvocationOffset(), 0, SharedASTProvider.WAIT_NO);
            ASTNode node = ((SourceRefElement)a).findNode(assistContext.getASTRoot());
            if (node == null) {
                node = assistContext.getCoveredNode();
            }
            if (!(node instanceof Annotation)) {
                return proposals;
            }
            LocationInformation locationInfo = null;
            if (node instanceof NormalAnnotation) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)node;
                List pairs = normalAnnotation.values();
                for (MemberValuePair pair : pairs) {
                    Expression expression2 = pair.getValue();
                    if (!(expression2 instanceof StringLiteral)) continue;
                    locationInfo = this.getLocationInformation((StringLiteral)expression2, javaContext);
                }
            } else if (node instanceof SingleMemberAnnotation && (expression = (singleMemberAnnotation = (SingleMemberAnnotation)node).getValue()) instanceof StringLiteral) {
                locationInfo = this.getLocationInformation((StringLiteral)expression, javaContext);
            }
            if (locationInfo == null) {
                return proposals;
            }
            int locationOffset = locationInfo.getOffset();
            int locationLength = locationInfo.getLength();
            String content = locationInfo.getFilter();
            if (invocationOffset >= locationOffset && invocationOffset <= locationOffset + locationLength) {
                int index = 0;
                boolean found = false;
                while (!found) {
                    int startIndex = content.indexOf("{");
                    if (startIndex < 0 || startIndex + locationOffset >= invocationOffset) break;
                    content = content.substring(startIndex + 1);
                    index += startIndex + 1;
                    if (content.contains("{")) continue;
                    found = true;
                }
                ++locationOffset;
                if (found) {
                    ISourceRange sourceRange = element.getSourceRange();
                    assistContext = new AssistContext(javaContext.getCompilationUnit(), (ISourceViewer)sourceViewer, sourceRange.getOffset(), sourceRange.getLength(), SharedASTProvider.WAIT_YES);
                    node = assistContext.getCoveringNode();
                    Annotation annotation = (Annotation)((SourceRefElement)a).findNode(assistContext.getASTRoot());
                    if (content.endsWith("}")) {
                        content = content.substring(0, content.length() - 1);
                    }
                    if (node instanceof MethodDeclaration) {
                        MethodDeclaration methodDecl = (MethodDeclaration)node;
                        proposals.addAll(this.getProposals(methodDecl, annotation, content, locationOffset, index, javaContext));
                    } else if (node instanceof TypeDeclaration) {
                        MethodDeclaration[] methodDecls;
                        TypeDeclaration typeDecl = (TypeDeclaration)node;
                        MethodDeclaration[] methodDeclarationArray = methodDecls = typeDecl.getMethods();
                        int n = methodDecls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MethodDeclaration methodDecl = methodDeclarationArray[n2];
                            proposals.addAll(this.getProposals(methodDecl, annotation, content, locationOffset, index, javaContext));
                            ++n2;
                        }
                    }
                }
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> getProposals(MethodDeclaration methodDecl, Annotation annotation, String filter, int valueOffset, int variableOffset, JavaContentAssistInvocationContext javaContext) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        List params = methodDecl.parameters();
        for (SingleVariableDeclaration param : params) {
            Set<Annotation> pathVariables;
            ITypeBinding typeBinding = param.getType().resolveBinding();
            if (ProposalCalculatorUtil.isKnownRequestMappingParamType(javaContext.getProject().getProject(), typeBinding) || (pathVariables = ProposalCalculatorUtil.findAnnotations("PathVariable", (ASTNode)param)).size() <= 0) continue;
            for (Annotation pathVariable : pathVariables) {
                String paramName;
                if (pathVariable instanceof SingleMemberAnnotation) {
                    String variableName;
                    Expression expression = ((SingleMemberAnnotation)pathVariable).getValue();
                    if (!(expression instanceof StringLiteral) || !(variableName = ((StringLiteral)expression).getLiteralValue()).startsWith(filter)) continue;
                    proposals.add((ICompletionProposal)new RequestMappingVariableCompletionProposal(param, variableName, valueOffset + variableOffset, filter.length(), annotation, methodDecl, javaContext));
                    continue;
                }
                if (!(pathVariable instanceof MarkerAnnotation) || !(paramName = param.getName().getFullyQualifiedName()).startsWith(filter)) continue;
                proposals.add((ICompletionProposal)new RequestMappingVariableCompletionProposal(param, paramName, valueOffset + variableOffset, filter.length(), annotation, methodDecl, javaContext));
            }
        }
        return proposals;
    }
}

