/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors.imports;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.QuickFixProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.springframework.ide.eclipse.quickfix.Activator;
import org.springframework.ide.eclipse.quickfix.jdt.processors.imports.AddImportRelevanceResolver;
import org.springframework.ide.eclipse.quickfix.jdt.processors.imports.AddImportRelevanceResolverFactory;
import org.springframework.ide.eclipse.quickfix.jdt.processors.imports.JDTQuickFixProcessorHelper;

public class AddImportsQuickFixProcessor
extends QuickFixProcessor {
    private AddImportRelevanceResolverFactory factory;

    public void setProposalRelevanceFactory(AddImportRelevanceResolverFactory factory) {
        if (factory != null) {
            this.factory = factory;
        }
    }

    protected AddImportRelevanceResolverFactory getFactory() {
        if (this.factory == null) {
            this.setProposalRelevanceFactory(new AddImportRelevanceResolverFactory());
        }
        return this.factory;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ICompilationUnit cu = context != null ? context.getCompilationUnit() : null;
        try {
            if (JDTQuickFixProcessorHelper.getInstance().removeJDTQuickFixProcessor(cu)) {
                return null;
            }
        }
        catch (Throwable e) {
            Activator.log(e);
        }
        if (JDTQuickFixProcessorHelper.getInstance().isJDTProcessorRemoved()) {
            IJavaCompletionProposal[] proposals = super.getCorrections(context, locations);
            if (proposals != null && proposals.length > 0) {
                List<IJavaCompletionProposal> proposalsFromJDT = Arrays.asList(proposals);
                try {
                    this.recomputeProposalRelevance(context, locations, proposalsFromJDT);
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
            return proposals;
        }
        return null;
    }

    protected void recomputeProposalRelevance(IInvocationContext context, IProblemLocation[] locations, List<IJavaCompletionProposal> proposalsFromJDT) throws Exception {
        if (context == null || locations == null || proposalsFromJDT == null) {
            return;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            Integer id = new Integer(problem.getProblemId());
            if (id != null && handledProblems.add(id)) {
                block0 : switch (id) {
                    case -1610612233: 
                    case 0x1000002: {
                        ICompilationUnit cu = context.getCompilationUnit();
                        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
                        if (selectedNode == null || cu == null) break;
                        int kind = this.evaluateTypeKind(selectedNode, cu.getJavaProject());
                        List<AddImportRelevanceResolver> relevanceResolvers = this.getFactory().getResolvers(cu, proposalsFromJDT);
                        if (relevanceResolvers == null) break;
                        for (AddImportRelevanceResolver resolver : relevanceResolvers) {
                            if (resolver.recomputeRelevance(kind, selectedNode)) break block0;
                        }
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private int evaluateTypeKind(ASTNode node, IJavaProject project) {
        int kind = ASTResolving.getPossibleTypeKinds((ASTNode)node, (boolean)JavaModelUtil.is50OrHigher((IJavaProject)project));
        return kind;
    }
}

