/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors.imports;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.quickfix.Activator;

public class JDTQuickFixProcessorHelper {
    public static final String ENABLE_STS_QUICKFIX_IMPORTS = "enable.sts.quickfix.imports";
    private ContributedProcessorDescriptor jdtProcessorDescriptor = null;
    private Boolean removeJDTQuickFixProcessor = null;
    private static JDTQuickFixProcessorHelper instance;

    private JDTQuickFixProcessorHelper() {
    }

    public static JDTQuickFixProcessorHelper getInstance() {
        if (instance == null) {
            instance = new JDTQuickFixProcessorHelper();
        }
        return instance;
    }

    public synchronized boolean removeJDTQuickFixProcessor(ICompilationUnit cu) throws Exception {
        if (this.jdtProcessorDescriptor != null || cu == null || !this.shouldRemoveJDTQuickfixProcessor()) {
            return false;
        }
        Class<?> quickFixProcessor = this.getJavaCorrectionProcessor();
        if (quickFixProcessor != null) {
            try {
                Field correctionProcessor = quickFixProcessor.getDeclaredField("fgContributedCorrectionProcessors");
                if (correctionProcessor != null) {
                    ContributedProcessorDescriptor[] descriptors;
                    correctionProcessor.setAccessible(true);
                    Object corrProcessorObj = correctionProcessor.get(null);
                    if (corrProcessorObj instanceof ContributedProcessorDescriptor[] && (descriptors = (ContributedProcessorDescriptor[])corrProcessorObj) != null) {
                        ArrayList<ContributedProcessorDescriptor> edited = new ArrayList<ContributedProcessorDescriptor>(descriptors.length);
                        ContributedProcessorDescriptor foundJDTProcessorToRemove = null;
                        ContributedProcessorDescriptor[] contributedProcessorDescriptorArray = descriptors;
                        int n = descriptors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ContributedProcessorDescriptor desc = contributedProcessorDescriptorArray[n2];
                            IQuickFixProcessor processor = (IQuickFixProcessor)desc.getProcessor(cu, IQuickFixProcessor.class);
                            if (processor != null) {
                                if (!processor.getClass().getName().equals("org.eclipse.jdt.internal.ui.text.correction.QuickFixProcessor")) {
                                    edited.add(desc);
                                } else {
                                    foundJDTProcessorToRemove = desc;
                                }
                            }
                            ++n2;
                        }
                        if (foundJDTProcessorToRemove != null) {
                            this.jdtProcessorDescriptor = foundJDTProcessorToRemove;
                            correctionProcessor.set(null, edited.toArray(new ContributedProcessorDescriptor[0]));
                            return true;
                        }
                    }
                }
            }
            catch (SecurityException e) {
                Activator.log(e);
            }
            catch (IllegalAccessException e) {
                Activator.log(e);
            }
            catch (IllegalArgumentException e) {
                Activator.log(e);
            }
            catch (NoSuchFieldException e) {
                Activator.log(e);
            }
        }
        return false;
    }

    public synchronized boolean isJDTProcessorRemoved() {
        return this.jdtProcessorDescriptor != null;
    }

    public synchronized boolean addJDTQuickFixProcessor(ICompilationUnit cu) {
        if (this.jdtProcessorDescriptor == null) {
            return false;
        }
        Class<?> quickFixProcessor = this.getJavaCorrectionProcessor();
        if (quickFixProcessor != null) {
            try {
                Field correctionProcessor = quickFixProcessor.getDeclaredField("fgContributedCorrectionProcessors");
                if (correctionProcessor != null) {
                    ContributedProcessorDescriptor[] descriptors;
                    correctionProcessor.setAccessible(true);
                    Object corrProcessorObj = correctionProcessor.get(null);
                    if (corrProcessorObj instanceof ContributedProcessorDescriptor[] && (descriptors = (ContributedProcessorDescriptor[])corrProcessorObj) != null) {
                        List<ContributedProcessorDescriptor> toEdit = Arrays.asList(descriptors);
                        boolean exists = false;
                        for (ContributedProcessorDescriptor desc : toEdit) {
                            IQuickFixProcessor curr = (IQuickFixProcessor)desc.getProcessor(cu, IQuickFixProcessor.class);
                            if (desc != this.jdtProcessorDescriptor && !curr.getClass().getName().equals("org.eclipse.jdt.internal.ui.text.correction.QuickFixProcessor")) continue;
                            exists = true;
                            break;
                        }
                        if (!exists && this.jdtProcessorDescriptor != null) {
                            toEdit.add(this.jdtProcessorDescriptor);
                            correctionProcessor.set(null, toEdit.toArray(new ContributedProcessorDescriptor[0]));
                            return true;
                        }
                    }
                }
            }
            catch (SecurityException e) {
                Activator.log(e);
            }
            catch (IllegalAccessException e) {
                Activator.log(e);
            }
            catch (IllegalArgumentException e) {
                Activator.log(e);
            }
            catch (NoSuchFieldException e) {
                Activator.log(e);
            }
        }
        return false;
    }

    protected Class<?> getJavaCorrectionProcessor() {
        Class processor = null;
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            try {
                processor = bundle.loadClass("org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor");
            }
            catch (Throwable throwable) {
                Activator.logInfo("Unable to find the JDT 'JavaCorrectionProcessor' registry. The STS 'Add Imports' quickfix processor may not be available as access to the registry is required to enable this feature.");
            }
        }
        return processor;
    }

    protected Bundle getBundle() {
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)"org.eclipse.jdt.ui");
        }
        catch (Throwable e) {
            Activator.log(e);
        }
        return bundle;
    }

    public synchronized boolean shouldRemoveJDTQuickfixProcessor() {
        if (this.removeJDTQuickFixProcessor == null) {
            Properties properties = System.getProperties();
            this.removeJDTQuickFixProcessor = properties == null || !properties.containsKey(ENABLE_STS_QUICKFIX_IMPORTS) || !"false".equals(properties.getProperty(ENABLE_STS_QUICKFIX_IMPORTS));
        }
        return this.removeJDTQuickFixProcessor;
    }
}

