/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.QuickfixReflectionUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class AddConstructorParamQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private final int numAdditionalParams;
    private final IMethod constructor;
    private final String label;
    private final IJavaProject javaProject;

    public AddConstructorParamQuickFixProposal(int offset, int length, boolean missingEndQuote, int numAdditionalParams, IMethod constructor, String label, IJavaProject javaProject) {
        super(offset, length, missingEndQuote);
        this.numAdditionalParams = numAdditionalParams;
        this.constructor = constructor;
        this.label = label;
        this.javaProject = javaProject;
    }

    @Override
    public void applyQuickFix(IDocument document) {
        try {
            int numParams = this.constructor.getNumberOfParameters();
            Object[] changeDesc = QuickfixReflectionUtils.createChangeDescriptionArray(numParams + this.numAdditionalParams);
            ITypeBinding objectBinding = QuickfixUtils.getTargetTypeBinding(this.javaProject, this.javaProject.findType("java.lang.Object"));
            int i = numParams;
            while (i < numParams + this.numAdditionalParams) {
                changeDesc[i] = QuickfixReflectionUtils.createInsertDescription(objectBinding, "obj" + (i + 1));
                ++i;
            }
            ICompilationUnit targetCU = this.constructor.getCompilationUnit();
            String[] paramTypes = new String[numParams];
            int i2 = 0;
            while (i2 < numParams) {
                paramTypes[i2] = "Object";
                ++i2;
            }
            IMethodBinding methodBinding = QuickfixUtils.getMethodBinding(this.javaProject, this.constructor);
            if (methodBinding != null) {
                ClassInstanceCreation invocationNode = QuickfixUtils.getMockConstructorInvocation(this.constructor.getDeclaringType().getFullyQualifiedName(), paramTypes);
                Object proposal = QuickfixReflectionUtils.createChangeMethodSignatureProposal(this.label, targetCU, invocationNode, methodBinding, changeDesc, 5, this.getImage());
                QuickfixReflectionUtils.applyProposal(proposal, document);
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
    }

    public String getDisplayString() {
        String additionalParams = "";
        int i = 0;
        while (i < this.numAdditionalParams) {
            if (i > 0) {
                additionalParams = String.valueOf(additionalParams) + ", ";
            }
            additionalParams = String.valueOf(additionalParams) + "'Object'";
            ++i;
        }
        return String.valueOf(this.label) + ": Add parameter " + additionalParams;
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif");
    }
}

