/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.internal.model.update.BeansModelUpdater;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;

public class AddToConfigSetQuickFixProposal
extends BeanAttributeQuickFixProposal
implements ICompletionProposal {
    private final IBeansConfigSet configSet;
    private final BeansProject project;
    private final IFile file;

    public AddToConfigSetQuickFixProposal(int offset, int length, boolean missingEndQuote, IFile file, IBeansConfigSet configSet, BeansProject project) {
        super(offset, length, missingEndQuote);
        this.configSet = configSet;
        this.project = project;
        this.file = file;
    }

    @Override
    public void applyQuickFix(IDocument document) {
        if (this.configSet instanceof BeansConfigSet) {
            BeansConfigSet newConfigSet = new BeansConfigSet((IBeansProject)this.project, this.configSet.getElementName(), this.configSet.getConfigNames(), this.configSet.getType());
            newConfigSet.addConfig(QuickfixUtils.getConfigName((IResource)this.file));
            this.project.removeConfigSet(this.configSet.getElementName());
            this.project.addConfigSet((IBeansConfigSet)newConfigSet);
            this.project.saveDescription();
            BeansModelUpdater.updateProject((IBeansProject)this.project);
        }
    }

    public String getDisplayString() {
        return "Add " + QuickfixUtils.getConfigName((IResource)this.file) + " to config set " + this.configSet.getElementName();
    }

    public Image getImage() {
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.configset_obj.gif");
    }
}

