/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.springframework.ide.eclipse.quickfix.rename.RenameBeanIdRefsRefactoring;

public class BeanRenameParticipant {
    private IMethod method;
    private String newName;

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isBean()) {
            return null;
        }
        IResource resource = this.method.getResource();
        if (resource instanceof IFile) {
            RenameBeanIdRefsRefactoring refactoring = new RenameBeanIdRefsRefactoring(this.method, this.newName);
            return refactoring.createChange(pm);
        }
        return null;
    }

    public String getName() {
        return "";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IMethod) {
            this.method = (IMethod)element;
            if (this.method.getCompilationUnit().getImport("org.springframework.context.annotation.Bean") != null) {
                this.method = (IMethod)element;
                return true;
            }
        }
        return false;
    }

    private boolean isBean() throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = this.method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if ("Bean".equals(annotation.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

