/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.core.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.BeansJavaCompletionProposal;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposal;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class XmlBackedContentProposalProvider
implements IContentProposalProvider {
    private IDOMElement input;
    private final String name;
    private ContentAssistRequest request;

    public XmlBackedContentProposalProvider(IDOMElement input, String attrName) {
        this.input = input;
        this.name = attrName;
    }

    protected abstract IContentAssistCalculator createContentAssistCalculator();

    protected IContentAssistContext createContentAssistContext(String contents) {
        return new DefaultContentAssistContext(this.request, this.name, contents);
    }

    protected IContentAssistProposalRecorder createContentAssistRecorder() {
        return new DefaultContentAssistProposalRecorder(this.request);
    }

    protected IDOMAttr getAttribute() {
        Attr attrNode = this.input.getAttributeNode(this.name);
        if (attrNode != null) {
            return (IDOMAttr)attrNode;
        }
        return null;
    }

    public String getAttributeName() {
        return this.name;
    }

    private ITextRegion getCompletionRegion() {
        IDOMAttr attr = this.getAttribute();
        if (attr != null) {
            return attr.getValueRegion();
        }
        return null;
    }

    protected IDOMElement getInput() {
        return this.input;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        this.request = null;
        if (this.getAttribute() != null && this.getCompletionRegion() != null) {
            int start = this.input.getStartStructuredDocumentRegion().getStart() + this.getCompletionRegion().getStart();
            this.request = new ContentAssistRequest((Node)this.input, (Node)this.input, this.input.getStartStructuredDocumentRegion(), this.getCompletionRegion(), start, this.getCompletionRegion().getLength(), contents);
        } else {
            this.request = new ContentAssistRequest((Node)this.input, (Node)this.input, this.input.getStartStructuredDocumentRegion(), this.getCompletionRegion(), position, contents.length(), contents);
        }
        IContentAssistContext context = this.createContentAssistContext(contents);
        IContentAssistProposalRecorder recorder = this.createContentAssistRecorder();
        IContentAssistCalculator calc = this.createContentAssistCalculator();
        calc.computeProposals(context, recorder);
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        ICompletionProposal[] results = this.request.getCompletionProposals();
        if (results != null && results.length > 0) {
            ICompletionProposal[] iCompletionProposalArray = this.request.getCompletionProposals();
            int n = iCompletionProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal completionProp = iCompletionProposalArray[n2];
                proposals.add(this.makeContentProposal(completionProp));
                ++n2;
            }
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private IContentProposal makeContentProposal(final ICompletionProposal proposal) {
        return new XmlBackedContentProposal(){

            public String getContent() {
                if (proposal instanceof BeansJavaCompletionProposal) {
                    BeansJavaCompletionProposal beanProp = (BeansJavaCompletionProposal)proposal;
                    String str = beanProp.getReplacementString();
                    if (str.startsWith("\"")) {
                        str = str.substring(1);
                    }
                    if (str.endsWith("\"")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    return str;
                }
                return proposal.getDisplayString();
            }

            public int getCursorPosition() {
                return this.getContent().length();
            }

            public String getDescription() {
                return ConfigCoreUtils.stripTags(proposal.getAdditionalProposalInfo());
            }

            @Override
            public Image getImage() {
                return proposal.getImage();
            }

            public String getLabel() {
                return proposal.getDisplayString();
            }
        };
    }

    void setInput(IDOMElement input) {
        this.input = input;
    }
}

